/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate.validator;

import org.tentackle.common.StringHelper;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationRuntimeException;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.Validator;

public abstract class AbstractValidationResult
implements ValidationResult {
    private static final long serialVersionUID = 415899327881601354L;
    private String message;
    private String errorCode;
    private String validationPath;
    private transient Object object;
    private transient Object parentObject;
    private Class<? extends ValidationScope>[] configuredScopes;
    private transient Validator validator;

    public AbstractValidationResult(Validator validator, ValidationContext validationContext, String message) {
        this.setValidator(validator, validationContext);
        this.message = message;
    }

    public AbstractValidationResult(Validator validator, ValidationContext validationContext, String message, String errorCode) {
        this(validator, validationContext, message);
        this.errorCode = errorCode;
    }

    public AbstractValidationResult() {
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.validator != null) {
            buf.append('[').append(this.validator).append("] ");
        }
        buf.append(this.validationPath).append(":");
        if (this.hasMessage()) {
            buf.append(' ').append(this.getMessage());
        }
        if (this.hasFailed()) {
            buf.append(" (FAILED)");
        } else {
            buf.append(" (PASSED)");
        }
        return buf.toString();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    protected void setValidator(Validator validator, ValidationContext validationContext) {
        if (validator == null) {
            throw new IllegalArgumentException("validator must not be null");
        }
        this.validator = validator;
        this.errorCode = validator.getErrorCode();
        this.validationPath = validationContext.getValidationPath();
        this.object = validationContext.getObject();
        this.parentObject = validationContext.getParentObject();
        this.configuredScopes = validator.getConfiguredScopes(validationContext);
    }

    @Override
    public boolean hasMessage() {
        return this.message != null && !this.message.isEmpty();
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getValidationPath() {
        return this.validationPath;
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public Object getParentObject() {
        return this.parentObject;
    }

    @Override
    public Class<? extends ValidationScope>[] getConfiguredScopes() {
        return this.configuredScopes;
    }

    @Override
    public ValidationResult.CollectionIndex[] getValidationCollectionIndexes() {
        int count = StringHelper.countOccurrences((String)this.validationPath, (char)'[');
        ValidationResult.CollectionIndex[] indexes = new ValidationResult.CollectionIndex[count];
        int ndx = 0;
        for (int i = 0; i < count; ++i) {
            if ((ndx = this.validationPath.indexOf(91, ndx + 1)) > 0) {
                ValidationResult.CollectionIndex colIndex;
                indexes[i] = colIndex = new ValidationResult.CollectionIndex();
                colIndex.pathPrefix = this.validationPath.substring(0, ndx);
                int ndx2 = this.validationPath.indexOf("].", ndx);
                if (ndx2 < 0) {
                    throw new ValidationRuntimeException("no closing bracket after '" + colIndex.pathPrefix + "' in validation path '" + this.validationPath + "'");
                }
                colIndex.pathPostfix = this.validationPath.substring(ndx2 + 2);
                try {
                    colIndex.index = Integer.parseInt(this.validationPath.substring(ndx + 1, ndx2));
                    ndx = ndx2 + 2;
                    continue;
                }
                catch (RuntimeException ex) {
                    throw new ValidationRuntimeException("cannot decode index in validation path '" + this.validationPath + "' after '" + colIndex.pathPrefix + "'");
                }
            }
            throw new ValidationRuntimeException("wrong number of indexes in '" + this.validationPath + "'. Expected=" + count + ", detected=" + (i + 1));
        }
        return indexes;
    }
}

