/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.StringHelper;
import org.tentackle.misc.CompoundValue;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.script.Script;
import org.tentackle.script.ScriptConverter;
import org.tentackle.script.ScriptVariable;
import org.tentackle.validate.DefaultScope;
import org.tentackle.validate.ScopeConfigurator;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationRuntimeException;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationUtilities;
import org.tentackle.validate.Validator;
import org.tentackle.validate.validator.MessageScriptConverter;
import org.tentackle.validate.validator.ValidationScriptConverter;

public abstract class AbstractValidator<T extends Annotation>
implements Validator {
    public static final String VAR_SCOPE = "scope";
    public static final String VAR_PATH = "path";
    public static final String VAR_VALUE = "value";
    public static final String VAR_CLASS = "clazz";
    private static final Map<String, ScriptConverter> MESSAGE_CONVERTER_MAP;
    private static final Map<String, ScriptConverter> VALIDATION_CONVERTER_MAP;
    protected T annotation;
    protected AnnotatedElement element;
    protected String validatedElementName;
    protected int validationIndex = -1;
    protected CompoundValue valueParameter;
    protected CompoundValue conditionParameter;
    protected CompoundValue messageParameter;

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public T getAnnotation() {
        return this.annotation;
    }

    @Override
    public Class<? extends ValidationScope>[] getConfiguredScopes(ValidationContext validationContext) {
        Class<? extends ValidationScope>[] scopes = this.getScope();
        if (scopes.length == 1 && DefaultScope.class.isAssignableFrom(scopes[0])) {
            if (validationContext != null && validationContext.getParentObject() instanceof ScopeConfigurator) {
                return ((ScopeConfigurator)validationContext.getParentObject()).getDefaultScopes();
            }
            return new Class[]{DefaultScope.class};
        }
        return scopes;
    }

    @Override
    public void setAnnotatedElement(AnnotatedElement element) {
        this.element = element;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.element;
    }

    @Override
    public void setValidatedElementName(String name) {
        this.validatedElementName = name;
    }

    @Override
    public String getValidatedElementName() {
        return this.validatedElementName;
    }

    @Override
    public void setValidationIndex(int index) {
        this.validationIndex = index;
    }

    @Override
    public int getValidationIndex() {
        return this.validationIndex;
    }

    @Override
    public boolean isConditionValid(ValidationContext validationContext) {
        String condition = this.getCondition();
        if (condition != null && !condition.isEmpty()) {
            if (this.conditionParameter == null) {
                this.conditionParameter = this.createConditionParameter(condition);
            }
            ScriptVariable[] variables = this.createScriptVariables(validationContext);
            Object value = this.conditionParameter.getValue(validationContext.getParentObject(), variables);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new ValidationRuntimeException("result of condition '" + condition + "' is not a Boolean");
        }
        return true;
    }

    protected CompoundValue createCompoundValue(String value, Class<?> clazz) {
        CompoundValue cv = new CompoundValue(value, clazz);
        cv.setScriptCached(true);
        cv.setScriptExecutedThreadSafe(true);
        return cv;
    }

    protected CompoundValue createValueParameter(String value, Class<?> clazz) {
        CompoundValue compVal = this.createCompoundValue(value, clazz);
        Script script = compVal.getScript();
        if (script != null) {
            script.setConverter(VALIDATION_CONVERTER_MAP.get(script.getLanguage().getName()));
        }
        return compVal;
    }

    protected CompoundValue createConditionParameter(String condition) {
        CompoundValue compVal = this.createCompoundValue(condition, Boolean.class);
        Script script = compVal.getScript();
        if (script != null) {
            script.setConverter(VALIDATION_CONVERTER_MAP.get(script.getLanguage().getName()));
        }
        return compVal;
    }

    protected CompoundValue createMessageParameter(String message) {
        CompoundValue compVal = this.createCompoundValue(message, String.class);
        Script script = compVal.getScript();
        if (script != null) {
            ScriptConverter converter = MESSAGE_CONVERTER_MAP.get(script.getLanguage().getName());
            if (converter == null) {
                throw new ValidationRuntimeException("missing message script converter for " + script.getLanguage());
            }
            script.setConverter(converter);
        }
        return compVal;
    }

    protected <V> V getValue(String value, Class<V> clazz, ValidationContext validationContext) {
        if (clazz == null && (clazz = validationContext.getType()) == null) {
            Object object = validationContext.getObject();
            if (object == null) {
                throw new ValidationRuntimeException("could not determine object's type for " + this);
            }
            clazz = object.getClass();
        }
        if (this.valueParameter == null) {
            this.valueParameter = this.createValueParameter(value, clazz);
        }
        Object parentObject = validationContext.getParentObject();
        ScriptVariable[] variables = this.createScriptVariables(validationContext);
        return (V)this.valueParameter.getValue(parentObject, variables);
    }

    protected Object getValue(String value, ValidationContext validationContext) {
        return this.getValue(value, null, validationContext);
    }

    protected String createMessage(String message, ValidationContext validationContext) {
        String annoMessage = this.getMessage();
        if (!annoMessage.isEmpty()) {
            ScriptVariable[] variables;
            Object parentObject;
            Object value;
            if (this.messageParameter == null) {
                this.messageParameter = this.createMessageParameter(annoMessage);
            }
            if ((value = this.messageParameter.getValue(parentObject = validationContext.getParentObject(), variables = this.createScriptVariables(validationContext))) != null) {
                return value.toString();
            }
        }
        return message;
    }

    protected List<? extends ValidationResult> createFailedValidationResult(String message, ValidationContext validationContext) {
        String msg = this.createMessage(message, validationContext);
        ValidationResult result = ValidationUtilities.getInstance().createFailedValidationResult(this, validationContext, msg == null || msg.isEmpty() ? message : msg);
        return List.of(result);
    }

    public <C> Comparable<C> assertComparable(C obj) {
        if (obj != null && !(obj instanceof Comparable)) {
            throw new ValidationRuntimeException(obj.getClass() + " is not a Comparable");
        }
        return (Comparable)obj;
    }

    protected ScriptVariable[] createScriptVariables(ValidationContext validationContext) {
        return new ScriptVariable[]{new ScriptVariable(VAR_SCOPE, validationContext.getEffectiveScope()), new ScriptVariable(VAR_PATH, validationContext.getValidationPath()), new ScriptVariable(VAR_VALUE, validationContext.getObject()), new ScriptVariable(VAR_CLASS, EffectiveClassProvider.getEffectiveClass(validationContext.getParentObject()))};
    }

    static {
        ScriptConverter converter;
        String language;
        MESSAGE_CONVERTER_MAP = new HashMap<String, ScriptConverter>();
        VALIDATION_CONVERTER_MAP = new HashMap<String, ScriptConverter>();
        for (Map.Entry entry : ServiceFactory.getServiceFinder().createNameMap(MessageScriptConverter.class.getName()).entrySet()) {
            try {
                language = StringHelper.stripEnclosingDoubleQuotes((String)((String)entry.getKey()));
                converter = (ScriptConverter)Class.forName((String)entry.getValue()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                MESSAGE_CONVERTER_MAP.put(language, converter);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new ValidationRuntimeException("message script converter configuration failed", ex);
            }
        }
        for (Map.Entry entry : ServiceFactory.getServiceFinder().createNameMap(ValidationScriptConverter.class.getName()).entrySet()) {
            try {
                language = StringHelper.stripEnclosingDoubleQuotes((String)((String)entry.getKey()));
                converter = (ScriptConverter)Class.forName((String)entry.getValue()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                VALIDATION_CONVERTER_MAP.put(language, converter);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new ValidationRuntimeException("validation script converter configuration failed", ex);
            }
        }
    }
}

