/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate.validator;

import java.util.Collections;
import java.util.List;
import org.tentackle.misc.CompoundValue;
import org.tentackle.script.ScriptVariable;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationSeverity;
import org.tentackle.validate.validator.AbstractValidator;
import org.tentackle.validate.validator.Pattern;

public class PatternImpl
extends AbstractValidator<Pattern> {
    protected CompoundValue patternParameter;
    protected java.util.regex.Pattern regex;

    @Override
    public String getMessage() {
        return ((Pattern)this.annotation).message();
    }

    @Override
    public String getErrorCode() {
        return ((Pattern)this.annotation).error();
    }

    @Override
    public Class<? extends ValidationSeverity>[] getSeverity() {
        return ((Pattern)this.annotation).severity();
    }

    @Override
    public int getPriority() {
        return ((Pattern)this.annotation).priority();
    }

    @Override
    public Class<? extends ValidationScope>[] getScope() {
        return ((Pattern)this.annotation).scope();
    }

    @Override
    public String getCondition() {
        return ((Pattern)this.annotation).condition();
    }

    @Override
    public List<? extends ValidationResult> validate(ValidationContext validationContext) {
        Object object = validationContext.getObject();
        if (object == null) {
            return ((Pattern)this.annotation).ignoreNulls() ? Collections.emptyList() : this.createFailedValidationResult("object is null", validationContext);
        }
        java.util.regex.Pattern pattern = this.getPattern(validationContext);
        return pattern.matcher(object.toString()).matches() ? Collections.emptyList() : this.createFailedValidationResult("'" + object + "' does not match '" + pattern.pattern() + "'", validationContext);
    }

    protected java.util.regex.Pattern getPattern(ValidationContext validationContext) {
        if (this.patternParameter == null) {
            this.patternParameter = this.createCompoundValue(((Pattern)this.annotation).value(), String.class);
        }
        if (this.regex == null || this.patternParameter.getType() != CompoundValue.Type.CONSTANT) {
            Object parentObject = validationContext.getParentObject();
            Object object = validationContext.getObject();
            ScriptVariable[] variables = new ScriptVariable[]{new ScriptVariable("value", object)};
            String pattern = (String)this.patternParameter.getValue(parentObject, variables);
            this.regex = java.util.regex.Pattern.compile(pattern, ((Pattern)this.annotation).flag());
        }
        return this.regex;
    }
}

