/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.validate.validator;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationResult;
import org.tentackle.validate.ValidationRuntimeException;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationSeverity;
import org.tentackle.validate.validator.AbstractValidator;
import org.tentackle.validate.validator.Size;

public class SizeImpl
extends AbstractValidator<Size> {
    @Override
    public String getMessage() {
        return ((Size)this.annotation).message();
    }

    @Override
    public String getErrorCode() {
        return ((Size)this.annotation).error();
    }

    @Override
    public Class<? extends ValidationSeverity>[] getSeverity() {
        return ((Size)this.annotation).severity();
    }

    @Override
    public int getPriority() {
        return ((Size)this.annotation).priority();
    }

    @Override
    public Class<? extends ValidationScope>[] getScope() {
        return ((Size)this.annotation).scope();
    }

    @Override
    public String getCondition() {
        return ((Size)this.annotation).condition();
    }

    @Override
    public List<? extends ValidationResult> validate(ValidationContext validationContext) {
        int size;
        Object object = validationContext.getObject();
        if (object == null) {
            return ((Size)this.annotation).ignoreNulls() ? Collections.emptyList() : this.createFailedValidationResult("object is null", validationContext);
        }
        if (object instanceof String) {
            size = ((String)object).length();
        } else if (object instanceof Collection) {
            size = ((Collection)object).size();
        } else if (object instanceof Map) {
            size = ((Map)object).size();
        } else if (object instanceof Array) {
            size = Array.getLength(object);
        } else {
            throw new ValidationRuntimeException("unsupported type: " + object.getClass().getName());
        }
        return size < ((Size)this.annotation).min() || size > ((Size)this.annotation).max() ? this.createFailedValidationResult("size = " + size + " (expected " + ((Size)this.annotation).min() + " <= size <= " + ((Size)this.annotation).max() + ")", validationContext) : Collections.emptyList();
    }
}

