/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.i18n;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.tentackle.common.BundleSupport;
import org.tentackle.common.Settings;
import org.tentackle.i18n.StoredBundleFactory;
import org.tentackle.maven.AbstractTentackleMojo;
import org.tentackle.maven.ProjectClassLoader;
import org.tentackle.maven.plugin.i18n.OrderedProperties;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;

public abstract class AbstractI18nMojo
extends AbstractTentackleMojo
implements DomainContextProvider {
    @Parameter(required=true)
    protected String url;
    @Parameter(required=true)
    public String user;
    @Parameter
    public String password;
    @Parameter
    protected String locales;
    protected List<String> localeSuffixes;
    protected DomainContext context;
    protected int bundleCount;
    protected int errors;
    protected int warnings;
    protected int updates;

    public DomainContext getDomainContext() {
        return this.context;
    }

    public void prepareExecute() {
        StoredBundleFactory.setEnabled((boolean)false);
    }

    public void executeImpl() throws MojoExecutionException {
        this.localeSuffixes = new ArrayList<String>();
        if (this.locales != null) {
            StringTokenizer stok = new StringTokenizer(this.locales, ",; \n\r\t");
            while (stok.hasMoreTokens()) {
                String localeName = stok.nextToken().replace('_', '-');
                if (localeName.isEmpty()) continue;
                this.localeSuffixes.add(localeName);
            }
        }
        Properties props = new Properties();
        props.setProperty("url", this.url);
        props.setProperty("user", this.user);
        props.setProperty("password", this.password);
        SessionInfo sessionInfo = Pdo.createSessionInfo((Properties)props);
        try (Session session = Pdo.createSession((SessionInfo)sessionInfo);){
            List<MavenProject> projects;
            session.makeCurrent();
            this.context = Pdo.createDomainContext((Session)session);
            ModificationTracker pdoTracker = ModificationTracker.getInstance();
            pdoTracker.setSession(session);
            if (this.isExecutionRecursive()) {
                projects = new ArrayList();
                projects.add(this.getMavenProject());
            } else {
                projects = this.getMavenProject().getCollectedProjects();
            }
            this.processBundles(session, projects);
        }
        this.getLog().info((CharSequence)(this.bundleCount + " bundle" + (this.bundleCount == 1 ? "" : "s") + " processed, " + this.warnings + " warning" + (this.warnings == 1 ? "" : "s") + ", " + this.errors + " error" + (this.errors == 1 ? "" : "s") + ", " + this.updates + " update" + (this.updates == 1 ? "" : "s")));
        if (this.errors > 0) {
            throw new MojoExecutionException("pushing to the database failed");
        }
    }

    protected void processBundles(Session session, List<MavenProject> projects) throws MojoExecutionException {
        try {
            for (MavenProject project : projects) {
                List classpathElements = project.getCompileClasspathElements();
                ProjectClassLoader classLoader = new ProjectClassLoader((URLClassLoader)((Object)((Object)this)).getClass().getClassLoader(), classpathElements);
                session.transaction(() -> this.lambda$processBundles$0((ClassLoader)classLoader));
            }
        }
        catch (DependencyResolutionRequiredException dx) {
            throw new MojoExecutionException("cannot determine classpath elements", (Exception)((Object)dx));
        }
        catch (MalformedURLException mx) {
            this.getLog().error((CharSequence)"cannot create project classloader", (Throwable)mx);
        }
        catch (RuntimeException rex) {
            throw new MojoExecutionException("processing the bundles failed", (Exception)rex);
        }
    }

    public abstract void processBundle(ClassLoader var1, String var2, String var3, String var4) throws MojoExecutionException;

    protected Properties loadProperties(ClassLoader classLoader, String resourceName) throws IOException {
        try (InputStream is = classLoader.getResourceAsStream(resourceName);){
            if (is != null) {
                InputStreamReader reader = new InputStreamReader(is, Settings.getEncodingCharset());
                OrderedProperties props = new OrderedProperties();
                props.load(reader);
                OrderedProperties orderedProperties = props;
                return orderedProperties;
            }
            Properties properties = null;
            return properties;
        }
    }

    protected Properties loadProperties(File file) throws IOException {
        if (file.exists()) {
            try (FileReader reader = new FileReader(file, Settings.getEncodingCharset());){
                OrderedProperties properties = new OrderedProperties();
                properties.load(reader);
                OrderedProperties orderedProperties = properties;
                return orderedProperties;
            }
        }
        return null;
    }

    private /* synthetic */ Object lambda$processBundles$0(ClassLoader classLoader) throws MojoExecutionException {
        block0: for (BundleSupport bundleSupport : BundleSupport.getBundles((ClassLoader)classLoader)) {
            String bundleName = bundleSupport.getBundleName();
            String suffix = null;
            Object resourceName = bundleName;
            Iterator<String> iter = this.localeSuffixes.iterator();
            while (true) {
                if (suffix != null) {
                    resourceName = bundleName + "_" + suffix;
                }
                resourceName = ((String)resourceName).replace('.', '/') + ".properties";
                if (this.verbosityLevel.isDebug()) {
                    this.getLog().debug((CharSequence)("processing " + (String)resourceName));
                }
                this.processBundle(classLoader, bundleName, suffix, (String)resourceName);
                if (!iter.hasNext()) continue block0;
                suffix = iter.next();
            }
        }
        return null;
    }
}

