/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.i18n;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.maven.plugin.i18n.AbstractI18nMojo;
import org.tentackle.session.Session;

public class AbstractVerifyMojo
extends AbstractI18nMojo {
    Set<StoredBundle> obsoleteBundles;
    Set<StoredBundleKey> obsoleteKeys;
    Set<Translation> missingTranslations;
    Set<Translation> differingTranslations;
    Map<String, StoredBundle> resourceBundleMap;
    Map<String, Properties> propertiesMap;

    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            this.missingTranslations = new TreeSet<Translation>();
            this.differingTranslations = new TreeSet<Translation>();
            this.obsoleteKeys = new HashSet<StoredBundleKey>();
            this.resourceBundleMap = new TreeMap<String, StoredBundle>();
            this.propertiesMap = new HashMap<String, Properties>();
            return true;
        }
        return false;
    }

    @Override
    protected void processBundles(Session session, List<MavenProject> projects) throws MojoExecutionException {
        this.obsoleteBundles = new HashSet<StoredBundle>(((StoredBundle)this.on(StoredBundle.class)).selectAll());
        super.processBundles(session, projects);
        Iterator<StoredBundle> iterator = this.obsoleteBundles.iterator();
        while (iterator.hasNext()) {
            StoredBundle bundle = iterator.next();
            Properties props = this.propertiesMap.get(bundle.getName());
            if (props != null) {
                iterator.remove();
                this.findObsoleteKeys(props, bundle);
                continue;
            }
            this.obsoleteKeys.removeIf(bundleKey -> bundleKey.getBundleId() == bundle.getId());
        }
    }

    @Override
    public void processBundle(ClassLoader classLoader, String bundleName, String locale, String resourceName) {
        this.resourceBundleMap.computeIfAbsent(resourceName, resName -> {
            ++this.bundleCount;
            StoredBundle bundle = null;
            try {
                Properties props = this.loadProperties(classLoader, (String)resName);
                if (props != null) {
                    bundle = this.verify(bundleName, locale, props);
                } else {
                    this.getLog().warn((CharSequence)("no such properties file: " + resName));
                    ++this.warnings;
                }
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)("could not load " + resName), (Throwable)ex);
                ++this.errors;
            }
            if (bundle == null) {
                bundle = (StoredBundle)this.on(StoredBundle.class);
            }
            return bundle;
        });
    }

    Collection<StoredBundle> sortBundles(Collection<StoredBundle> bundles) {
        ArrayList<StoredBundle> list = new ArrayList<StoredBundle>(bundles);
        list.sort((o1, o2) -> {
            int rv = o1.getName().compareTo(o2.getName());
            if (rv == 0) {
                rv = AbstractVerifyMojo.nullSafe(o1.getLocale()).compareTo(AbstractVerifyMojo.nullSafe(o2.getLocale()));
            }
            return rv;
        });
        return list;
    }

    Collection<StoredBundleKey> sortBundleKeys(Collection<StoredBundleKey> bundlesKeys) {
        ArrayList<StoredBundleKey> list = new ArrayList<StoredBundleKey>(bundlesKeys);
        list.sort((o1, o2) -> {
            int rv = o1.getBundle().getName().compareTo(o2.getBundle().getName());
            if (rv == 0 && (rv = AbstractVerifyMojo.nullSafe(o1.getBundle().getLocale()).compareTo(AbstractVerifyMojo.nullSafe(o2.getBundle().getLocale()))) == 0) {
                rv = o1.getKey().compareTo(o2.getKey());
            }
            return rv;
        });
        return list;
    }

    private StoredBundle verify(String bundleName, String locale, Properties props) {
        StoredBundle bundle = ((StoredBundle)this.on(StoredBundle.class)).findByNameAndLocale(bundleName, locale);
        if (bundle != null) {
            this.obsoleteBundles.remove(bundle);
            if (locale == null) {
                this.propertiesMap.put(bundle.getName(), props);
            }
            this.findDivergingTranslations(props, bundle);
            this.findObsoleteKeys(props, bundle);
        }
        return bundle;
    }

    private void findDivergingTranslations(Properties props, StoredBundle bundle) {
        for (String key : props.stringPropertyNames()) {
            String propValue = props.getProperty(key);
            String dbValue = bundle.getTranslation(key);
            if (dbValue == null) {
                this.missingTranslations.add(new Translation(bundle, key));
                continue;
            }
            if (Objects.equals(propValue, dbValue)) continue;
            this.differingTranslations.add(new Translation(bundle, key));
        }
    }

    private void findObsoleteKeys(Properties props, StoredBundle bundle) {
        for (StoredBundleKey bundleKey : bundle.getKeys()) {
            String propValue = props.getProperty(bundleKey.getKey());
            if (propValue != null) continue;
            this.obsoleteKeys.add(bundleKey);
        }
    }

    private static String nullSafe(String s) {
        return s == null ? "" : s;
    }

    static class Translation
    implements Comparable<Translation> {
        final StoredBundle bundle;
        final String key;

        Translation(StoredBundle bundle, String key) {
            this.bundle = bundle;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Translation that = (Translation)o;
            if (!this.bundle.equals(that.bundle)) {
                return false;
            }
            return this.key.equals(that.key);
        }

        public int hashCode() {
            int result = this.bundle.hashCode();
            result = 31 * result + this.key.hashCode();
            return result;
        }

        @Override
        public int compareTo(Translation o) {
            int rv = this.bundle.getName().compareTo(o.bundle.getName());
            if (rv == 0 && (rv = AbstractVerifyMojo.nullSafe(this.bundle.getLocale()).compareTo(AbstractVerifyMojo.nullSafe(o.bundle.getLocale()))) == 0) {
                rv = this.key.compareTo(o.key);
            }
            return rv;
        }
    }
}

