/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.i18n;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.maven.plugin.i18n.AbstractVerifyMojo;
import org.tentackle.session.Session;

@Mojo(name="cleanup", aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CleanupMojo
extends AbstractVerifyMojo {
    @Override
    protected void processBundles(Session session, List<MavenProject> projects) throws MojoExecutionException {
        super.processBundles(session, projects);
        this.warnings += this.resourceBundleMap.entrySet().stream().filter(entry -> ((StoredBundle)entry.getValue()).isNew()).map(Map.Entry::getKey).toList().size();
        this.warnings += this.missingTranslations.stream().filter(translation -> translation.bundle.getLocale() != null).toList().size();
        this.errors += this.missingTranslations.stream().filter(translation -> translation.bundle.getLocale() == null).toList().size();
        if (this.errors > 0) {
            this.getLog().error((CharSequence)(this.errors + " error" + (this.errors > 1 ? "s" : "") + " found -> please run tentackle-i18n:verify and fix the errors"));
        } else if (this.warnings > 0) {
            this.getLog().warn((CharSequence)(this.warnings + " warning" + (this.warnings > 1 ? "s" : "") + " found -> please run tentackle-i18n:verify and fix the warnings"));
        } else {
            this.updates += ((Integer)session.transaction(() -> {
                int count = 0;
                StringBuilder buf = new StringBuilder();
                HashSet<StoredBundle> bundles = new HashSet<StoredBundle>();
                for (StoredBundleKey bundleKey : this.sortBundleKeys(this.obsoleteKeys)) {
                    StoredBundle bundle2 = bundleKey.getBundle();
                    buf.append("\ntranslation ").append(bundle2).append(" '").append(bundleKey.getKey());
                    bundle2.setTranslation(bundleKey.getKey(), null);
                    bundles.add(bundle2);
                }
                bundles.forEach(bundle -> bundle.save());
                count += this.obsoleteKeys.size();
                for (StoredBundle bundle3 : this.sortBundles(this.obsoleteBundles)) {
                    buf.append("\nbundle ").append(bundle3).append(" with translations:");
                    for (StoredBundleKey key : bundle3.getKeys()) {
                        buf.append("\n    '").append(key.getKey()).append("'");
                        ++count;
                    }
                    bundle3.delete();
                }
                if ((count += this.obsoleteBundles.size()) > 0) {
                    this.getLog().warn((CharSequence)(count + " objects removed from " + this.url + ":" + buf));
                }
                return count;
            })).intValue();
        }
    }
}

