/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.i18n;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.common.Settings;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.maven.PackageInfo;
import org.tentackle.maven.plugin.i18n.AbstractI18nMojo;
import org.tentackle.maven.plugin.i18n.OrderedProperties;
import org.tentackle.reflect.ReflectionHelper;

@Mojo(name="pull", requiresDependencyResolution=ResolutionScope.COMPILE)
public class PullMojo
extends AbstractI18nMojo {
    private Map<String, PackageInfo> packageMap;

    protected boolean validate() throws MojoExecutionException {
        if (super.validate()) {
            this.packageMap = this.createPackageMap(true);
            return true;
        }
        return false;
    }

    @Override
    public void processBundle(ClassLoader classLoader, String bundleName, String locale, String resourceName) throws MojoExecutionException {
        StoredBundle bundle = ((StoredBundle)this.on(StoredBundle.class)).findByNameAndLocale(bundleName, locale);
        String packageName = ReflectionHelper.getPackageName((String)bundleName);
        PackageInfo info = this.packageMap.get(packageName);
        if (info != null) {
            Properties properties;
            ++this.bundleCount;
            int ndx = resourceName.lastIndexOf(47);
            String fileName = ndx >= 0 ? resourceName.substring(ndx + 1) : resourceName;
            File file = new File(info.getPath(), fileName);
            boolean differs = false;
            try {
                properties = this.loadProperties(file);
                if (properties == null) {
                    this.getLog().warn((CharSequence)("created resource: " + resourceName));
                    ++this.warnings;
                    properties = new OrderedProperties();
                }
                for (StoredBundleKey bundleKey : bundle.getKeys()) {
                    String propValue = properties.getProperty(bundleKey.getKey());
                    if (bundleKey.getValue().equals(propValue)) continue;
                    properties.setProperty(bundleKey.getKey(), bundleKey.getValue());
                    this.getLog().info((CharSequence)(resourceName + ": '" + bundleKey.getKey() + "' " + (propValue == null ? "added" : "updated")));
                    ++this.updates;
                    differs = true;
                }
            }
            catch (IOException iox) {
                this.getLog().error((CharSequence)("cannot load resource bundle properties file " + file.getAbsolutePath()), (Throwable)iox);
                ++this.errors;
                return;
            }
            if (differs) {
                try (FileWriter writer = new FileWriter(file, Settings.getEncodingCharset());){
                    String comment = "pulled from " + this.url + " by " + System.getProperty("user.name") + "@" + this.getHostName();
                    properties.store(writer, comment);
                }
                catch (IOException iox) {
                    this.getLog().error((CharSequence)("cannot update resource bundle properties file " + file.getAbsolutePath()), (Throwable)iox);
                    ++this.errors;
                }
            }
        }
    }
}

