/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.i18n;

import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.maven.plugin.i18n.AbstractI18nMojo;

@Mojo(name="push", requiresDependencyResolution=ResolutionScope.COMPILE)
public class PushMojo
extends AbstractI18nMojo {
    @Parameter
    protected boolean override;

    @Override
    public void processBundle(ClassLoader classLoader, String bundleName, String locale, String resourceName) {
        ++this.bundleCount;
        try {
            Properties props = this.loadProperties(classLoader, resourceName);
            if (props != null) {
                this.push(bundleName, locale, props);
            } else {
                this.getLog().warn((CharSequence)("no such resource: " + resourceName));
                ++this.warnings;
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("could not load " + resourceName), (Throwable)ex);
            ++this.errors;
        }
    }

    private void push(String bundleName, String locale, Properties props) {
        StoredBundle bundle = ((StoredBundle)this.on(StoredBundle.class)).findByNameAndLocale(bundleName, locale);
        if (bundle == null) {
            bundle = (StoredBundle)this.on(StoredBundle.class);
            bundle.setName(bundleName);
            bundle.setLocale(locale);
        }
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            String oldValue = bundle.getTranslation(key);
            if (oldValue != null && (!this.override || Objects.equals(value, oldValue))) continue;
            bundle.setTranslation(key, value);
            ++this.updates;
        }
        if (bundle.isModified()) {
            bundle.save();
        }
    }
}

