/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.maven.plugin.i18n;

import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.tentackle.i18n.pdo.StoredBundle;
import org.tentackle.i18n.pdo.StoredBundleKey;
import org.tentackle.maven.plugin.i18n.AbstractVerifyMojo;
import org.tentackle.session.Session;

@Mojo(name="verify", aggregator=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class VerifyMojo
extends AbstractVerifyMojo {
    @Override
    protected void processBundles(Session session, List<MavenProject> projects) throws MojoExecutionException {
        StoredBundle bundle;
        List<AbstractVerifyMojo.Translation> missingTrans;
        List<String> resourceNames;
        StringBuilder buf;
        super.processBundles(session, projects);
        if (!this.differingTranslations.isEmpty()) {
            StringBuilder buf2 = new StringBuilder();
            this.appendCount(buf2, this.differingTranslations.size(), " differing translation");
            StoredBundle bundle2 = null;
            for (AbstractVerifyMojo.Translation translation2 : this.differingTranslations) {
                if (!translation2.bundle.equals(bundle2)) {
                    bundle2 = translation2.bundle;
                    buf2.append('\n').append(bundle2).append(':');
                }
                buf2.append(" '").append(translation2.key).append("'");
            }
            this.updates += this.differingTranslations.size();
            this.getLog().info((CharSequence)buf2);
        }
        if (!this.obsoleteBundles.isEmpty()) {
            buf = new StringBuilder();
            this.appendCount(buf, this.obsoleteBundles.size(), " obsolete bundle");
            for (StoredBundle storedBundle : this.sortBundles(this.obsoleteBundles)) {
                buf.append('\n').append(storedBundle);
            }
            this.warnings += this.obsoleteBundles.size();
            this.getLog().warn((CharSequence)buf);
        }
        if (!this.obsoleteKeys.isEmpty()) {
            buf = new StringBuilder();
            this.appendCount(buf, this.obsoleteKeys.size(), " obsolete bundle key");
            StoredBundle bundle2 = null;
            for (StoredBundleKey bundleKey : this.sortBundleKeys(this.obsoleteKeys)) {
                if (!bundleKey.getBundle().equals(bundle2)) {
                    bundle2 = bundleKey.getBundle();
                    buf.append('\n').append(bundle2).append(':');
                }
                buf.append(" '").append(bundleKey.getKey()).append("'");
            }
            this.warnings += this.obsoleteKeys.size();
            this.getLog().warn((CharSequence)buf);
        }
        if (!(resourceNames = this.resourceBundleMap.entrySet().stream().filter(entry -> ((StoredBundle)entry.getValue()).isNew()).map(Map.Entry::getKey).toList()).isEmpty()) {
            StringBuilder buf3 = new StringBuilder();
            this.appendCount(buf3, resourceNames.size(), " missing stored bundle");
            for (String resourceName : resourceNames) {
                buf3.append(' ').append(resourceName);
            }
            this.warnings += resourceNames.size();
            this.getLog().warn((CharSequence)buf3);
        }
        if (!(missingTrans = this.missingTranslations.stream().filter(translation -> translation.bundle.getLocale() != null).toList()).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendCount(stringBuilder, missingTrans.size(), " missing translation");
            bundle = null;
            for (AbstractVerifyMojo.Translation translation3 : missingTrans) {
                if (!translation3.bundle.equals(bundle)) {
                    bundle = translation3.bundle;
                    stringBuilder.append('\n').append(bundle).append(':');
                }
                stringBuilder.append(" '").append(translation3.key).append("'");
            }
            this.warnings += missingTrans.size();
            this.getLog().warn((CharSequence)stringBuilder);
        }
        if (!(missingTrans = this.missingTranslations.stream().filter(translation -> translation.bundle.getLocale() == null).toList()).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendCount(stringBuilder, missingTrans.size(), " missing default translation");
            bundle = null;
            for (AbstractVerifyMojo.Translation translation2 : missingTrans) {
                if (!translation2.bundle.equals(bundle)) {
                    bundle = translation2.bundle;
                    stringBuilder.append('\n').append(bundle).append(':');
                }
                stringBuilder.append(" '").append(translation2.key).append("'");
            }
            this.errors += missingTrans.size();
            this.getLog().error((CharSequence)stringBuilder);
        }
    }

    private void appendCount(StringBuilder buf, int count, String text) {
        buf.append(count).append(text);
        if (count > 1) {
            buf.append('s');
        }
        buf.append(':');
    }
}

