// wurblet generated by Wurbelizer 11.2.3.1, see https://wurbelizer.org

package org.tentackle.wurblet;

import java.util.*;
import java.io.*;
import org.tentackle.common.*;
import org.wurbelizer.wurbel.*;
import org.tentackle.model.*;
import org.wurbelizer.wurblet.*;

/**
 * <strong>({@code @wurblet})</strong> Generate code to define the column lengths.
 * <p>
 * usage:<br>
 * &#064;wurblet &lt;tag&gt; ColumnLengths [--noif]
 * <p>
 * arguments:
 * <ul>
 * <li><em>--noif:</em> if not part of an interface (adds "public static final")</li>
 * </ul>
 * For more options, see {@link ModelWurblet}.
 */
public class ColumnLengths extends ModelWurblet {

  @Override
  public void run() throws WurbelException {
    super.run();
    try {
      wurbel();
    }
    catch (Throwable t) {
      if (t instanceof WurbelException) {
        throw (WurbelException) t;
      }
      throw new WurbelException("wurblet " + this + " failed", t);
    }
  }

  // ----------------- begin wurblet code -----------------

  private void wurbel() throws ModelException {
    String lead = getOption("noif") == null ? "" : "public static final ";
    for (Attribute attr: getEntity().getAttributes())  {
      if ((attr.getDataType() == DataType.STRING ||
           attr.getDataType() == DataType.APPLICATION && attr.getInnerType() == DataType.STRING) &&
          attr.getSize() != null && !attr.getOptions().isNoConstant() && !attr.getOptions().isFromSuper())  {
            out.print(source[0]); // 21:2 = "  /** maximum number of characters for ..."
            out.print(attr);
            out.print(source[1]); // 23:48 = "'. */  "
            out.print(lead);
            out.print(source[2]); // 24:10 = "int CL_"
            out.print(attr.getName().toUpperCase());
            out.print(source[3]); // 24:49 = " = "
            out.print(attr.getSize());
            out.print(source[4]); // 24:70 = ";"
      }
    }
  }

  // ----------------- end wurblet code -----------------
}
