/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.kit;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.angela.common.TerracottaCommandLineEnvironment;
import org.terracotta.angela.common.TerracottaVoter;
import org.terracotta.angela.common.TerracottaVoterInstance;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.tcconfig.SecurityRootDirectory;

public class VoterInstall {
    private final Distribution distribution;
    private final File kitLocation;
    private final File workingDir;
    private final SecurityRootDirectory securityRootDirectory;
    private final TerracottaCommandLineEnvironment tcEnv;
    private final Map<String, TerracottaVoterInstance> terracottaVoterInstances = new HashMap<String, TerracottaVoterInstance>();

    public VoterInstall(Distribution distribution, File kitLocation, File workingDir, SecurityRootDirectory securityRootDirectory, TerracottaCommandLineEnvironment tcEnv) {
        this.distribution = distribution;
        this.kitLocation = kitLocation;
        this.workingDir = workingDir;
        this.securityRootDirectory = securityRootDirectory;
        this.tcEnv = tcEnv;
    }

    public File getKitLocation() {
        return this.kitLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerracottaVoterInstance getTerracottaVoterInstance(TerracottaVoter terracottaVoter) {
        Map<String, TerracottaVoterInstance> map = this.terracottaVoterInstances;
        synchronized (map) {
            return this.terracottaVoterInstances.get(terracottaVoter.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVoter(TerracottaVoter terracottaVoter) {
        Map<String, TerracottaVoterInstance> map = this.terracottaVoterInstances;
        synchronized (map) {
            TerracottaVoterInstance terracottaVoterInstance = new TerracottaVoterInstance(terracottaVoter, this.distribution.createDistributionController(), this.kitLocation, this.workingDir, this.securityRootDirectory, this.tcEnv);
            this.terracottaVoterInstances.put(terracottaVoter.getId(), terracottaVoterInstance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeVoter(TerracottaVoter terracottaVoter) {
        Map<String, TerracottaVoterInstance> map = this.terracottaVoterInstances;
        synchronized (map) {
            this.terracottaVoterInstances.remove(terracottaVoter.getId());
            return this.terracottaVoterInstances.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int terracottaVoterInstanceCount() {
        Map<String, TerracottaVoterInstance> map = this.terracottaVoterInstances;
        synchronized (map) {
            return this.terracottaVoterInstances.size();
        }
    }
}

