/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.agent.com;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.ignite.Ignite;
import org.apache.ignite.configuration.CollectionConfiguration;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.agent.Agent;
import org.terracotta.angela.agent.client.RemoteClientManager;
import org.terracotta.angela.agent.com.AgentGroup;
import org.terracotta.angela.agent.com.AgentID;
import org.terracotta.angela.agent.com.Executor;
import org.terracotta.angela.agent.com.FileTransfer;
import org.terracotta.angela.agent.com.IgniteAgentGroup;
import org.terracotta.angela.agent.com.IgniteFutureAdapter;
import org.terracotta.angela.agent.kit.RemoteKitManager;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.cluster.Cluster;
import org.terracotta.angela.common.distribution.Distribution;
import org.terracotta.angela.common.topology.InstanceId;
import org.terracotta.angela.common.util.IpUtils;

public class IgniteLocalExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(IgniteLocalExecutor.class);
    protected final UUID group;
    protected final Ignite ignite;
    protected final AgentID agentID;
    protected final IgniteAgentGroup agentGroup;

    public IgniteLocalExecutor(Agent agent) {
        this(agent.getGroupId(), agent.getAgentID(), agent.getIgnite());
    }

    public IgniteLocalExecutor(UUID group, AgentID agentID, Ignite ignite) {
        this.group = group;
        this.agentID = agentID;
        this.ignite = ignite;
        this.agentGroup = new IgniteAgentGroup(group, agentID, ignite);
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    @Override
    public void close() {
        CompletableFuture<Void> future = CompletableFuture.allOf((CompletableFuture[])this.agentGroup.getSpawnedAgents().parallelStream().filter(Predicate.isEqual(this.getLocalAgentID()).negate()).map(this::shutdown).filter(Optional::isPresent).map(Optional::get).toArray(CompletableFuture[]::new));
        try {
            future.get(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e.getCause());
        }
        catch (TimeoutException e) {
            logger.warn("Some agents did not shutdown within 20 seconds: {}", this.agentGroup.getSpawnedAgents(), (Object)e);
        }
    }

    @Override
    public void uploadClientJars(AgentID agentID, InstanceId instanceId, List<Path> locations) {
        Future<Void> remoteDownloadFuture = this.executeAsync(agentID, (IgniteRunnable & Serializable)() -> this.downloadFiles(instanceId, new RemoteClientManager(instanceId).getClientClasspathRoot()));
        this.uploadFiles(instanceId, locations, remoteDownloadFuture);
    }

    @Override
    public void uploadKit(AgentID agentID, InstanceId instanceId, Distribution distribution, String kitInstallationName, Path kitInstallationPath) {
        Future<Void> remoteDownloadFuture = this.executeAsync(agentID, (IgniteRunnable & Serializable)() -> {
            RemoteKitManager remoteKitManager = new RemoteKitManager(instanceId, distribution, kitInstallationName);
            Path installDir = remoteKitManager.getKitInstallationPath().getParent();
            this.downloadFiles(instanceId, installDir);
        });
        this.uploadFiles(instanceId, Collections.singletonList(kitInstallationPath), remoteDownloadFuture);
    }

    @Override
    public Optional<CompletableFuture<Void>> shutdown(AgentID agentID) {
        if (this.getLocalAgentID().equals(agentID)) {
            throw new IllegalArgumentException("Cannot kill myself: " + agentID);
        }
        return this.agentGroup.requestShutdown(agentID);
    }

    public String toString() {
        return this.getLocalAgentID().toString();
    }

    @Override
    public AgentID getLocalAgentID() {
        return this.agentID;
    }

    @Override
    public synchronized Optional<AgentID> findAgentID(String hostname) {
        return Optional.ofNullable(IpUtils.isLocal((String)hostname) ? this.getLocalAgentID() : (AgentID)this.agentGroup.findRemoteAgentID(hostname).orElse(null));
    }

    @Override
    public synchronized AgentGroup getGroup() {
        return this.agentGroup;
    }

    @Override
    public Cluster getCluster() {
        return new Cluster(this.ignite, this.agentID, null);
    }

    @Override
    public Cluster getCluster(ClientId clientId) {
        return new Cluster(this.ignite, this.agentID, clientId);
    }

    @Override
    public Future<Void> executeAsync(AgentID agentID, IgniteRunnable job) {
        logger.debug("Executing job on: {}", (Object)agentID);
        return this.agentGroup.clusterGroup(agentID).map(clusterGroup -> new IgniteFutureAdapter(agentID, this.ignite.compute(clusterGroup).runAsync(job))).orElseThrow(() -> new IllegalArgumentException("No agent found matching: " + agentID + " in group " + this.group));
    }

    @Override
    public <R> Future<R> executeAsync(AgentID agentID, IgniteCallable<R> job) {
        logger.debug("Executing job on: {}", (Object)agentID);
        return this.agentGroup.clusterGroup(agentID).map(clusterGroup -> new IgniteFutureAdapter(agentID, this.ignite.compute(clusterGroup).callAsync(job))).orElseThrow(() -> new IllegalArgumentException("No agent found matching: " + agentID + " in group " + this.group));
    }

    @Override
    public BlockingQueue<FileTransfer> getFileTransferQueue(InstanceId instanceId) {
        return this.ignite.queue(instanceId + "@file-transfer-queue", 500, new CollectionConfiguration().setGroupName(this.group.toString()));
    }

    @Override
    public Optional<AgentID> startRemoteAgent(String hostname) {
        this.agentGroup.joined(this.getLocalAgentID(), hostname);
        return Optional.empty();
    }
}

