/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import java.util.Collection;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class DiscoveryEvent
extends EventAdapter {
    private static final long serialVersionUID = 0L;
    private ClusterNode evtNode;
    private long topVer;
    private Collection<ClusterNode> topSnapshot;

    @Override
    public String shortDisplay() {
        return this.name() + ": id8=" + U.id8(this.evtNode.id()) + ", ip=" + F.first(this.evtNode.addresses());
    }

    public DiscoveryEvent() {
    }

    public DiscoveryEvent(ClusterNode node, String msg, int type, ClusterNode evtNode) {
        super(node, msg, type);
        this.evtNode = evtNode;
    }

    public void eventNode(ClusterNode evtNode) {
        this.evtNode = evtNode;
    }

    public ClusterNode eventNode() {
        return this.evtNode;
    }

    public long topologyVersion() {
        return this.topVer;
    }

    public Collection<ClusterNode> topologyNodes() {
        return this.topSnapshot;
    }

    public void topologySnapshot(long topVer, Collection<ClusterNode> topSnapshot) {
        this.topVer = topVer;
        this.topSnapshot = topSnapshot;
    }

    @Override
    public String toString() {
        return S.toString(DiscoveryEvent.class, this, "nodeId8", U.id8(this.node().id()), "msg", (Object)this.message(), "type", (Object)this.name(), "tstamp", this.timestamp());
    }
}

