/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgfsEvent
extends EventAdapter {
    private static final long serialVersionUID = 0L;
    private final IgfsPath path;
    private IgfsPath newPath;
    private long dataSize;
    @GridToStringInclude
    private Map<String, String> meta;

    public IgfsEvent(IgfsPath path, ClusterNode node, int type) {
        super(node, "IGFS event.", type);
        this.path = path;
    }

    public IgfsEvent(IgfsPath path, IgfsPath newPath, ClusterNode node, int type) {
        this(path, node, type);
        this.newPath = newPath;
    }

    public IgfsEvent(IgfsPath path, ClusterNode node, int type, long dataSize) {
        this(path, node, type);
        this.dataSize = dataSize;
    }

    public IgfsEvent(IgfsPath path, ClusterNode node, int type, Map<String, String> meta) {
        this(path, node, type);
        this.meta = meta;
    }

    public IgfsPath path() {
        return this.path;
    }

    @Nullable
    public IgfsPath newPath() {
        return this.newPath;
    }

    public long dataSize() {
        return this.dataSize;
    }

    @Nullable
    public Map<String, String> updatedMeta() {
        return this.meta;
    }

    public boolean isDirectory() {
        int t = this.type();
        return t == 124 || t == 125 || t == 126;
    }

    @Override
    public String toString() {
        return S.toString(IgfsEvent.class, this, super.toString());
    }
}

