/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContextImpl;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.tx.VisorTxInfo;
import org.apache.ignite.internal.visor.tx.VisorTxOperation;
import org.apache.ignite.internal.visor.tx.VisorTxProjection;
import org.apache.ignite.internal.visor.tx.VisorTxSortOrder;
import org.apache.ignite.internal.visor.tx.VisorTxTask;
import org.apache.ignite.internal.visor.tx.VisorTxTaskArg;
import org.apache.ignite.internal.visor.tx.VisorTxTaskResult;
import org.apache.ignite.mxbean.TransactionsMXBean;

public class TransactionsMXBeanImpl
implements TransactionsMXBean {
    private final GridKernalContextImpl ctx;

    public TransactionsMXBeanImpl(GridKernalContextImpl ctx) {
        this.ctx = ctx;
    }

    @Override
    public String getActiveTransactions(Long minDuration, Integer minSize, String prj, String consistentIds, String xid, String lbRegex, Integer limit, String order, boolean detailed, boolean kill) {
        try {
            IgniteCompute compute = this.ctx.cluster().get().compute();
            VisorTxProjection proj = null;
            if (prj != null) {
                if ("clients".equals(prj)) {
                    proj = VisorTxProjection.CLIENT;
                } else if ("servers".equals(prj)) {
                    proj = VisorTxProjection.SERVER;
                }
            }
            List<String> consIds = null;
            if (consistentIds != null) {
                consIds = Arrays.stream(consistentIds.split(",")).collect(Collectors.toList());
            }
            VisorTxSortOrder sortOrder = null;
            if (order != null) {
                sortOrder = VisorTxSortOrder.valueOf(order.toUpperCase());
            }
            VisorTxTaskArg arg = new VisorTxTaskArg(kill ? VisorTxOperation.KILL : VisorTxOperation.LIST, limit, minDuration == null ? null : Long.valueOf(minDuration * 1000L), minSize, null, proj, consIds, xid, lbRegex, sortOrder, null);
            Map<ClusterNode, VisorTxTaskResult> res = compute.execute(new VisorTxTask(), new VisorTaskArgument<VisorTxTaskArg>(this.ctx.cluster().get().localNode().id(), arg, false));
            if (detailed) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                for (Map.Entry<ClusterNode, VisorTxTaskResult> entry : res.entrySet()) {
                    if (entry.getValue().getInfos().isEmpty()) continue;
                    ClusterNode key = entry.getKey();
                    w.println(key.toString());
                    for (VisorTxInfo info : entry.getValue().getInfos()) {
                        w.println(info.toUserString());
                    }
                }
                w.flush();
                return sw.toString();
            }
            int cnt = 0;
            for (VisorTxTaskResult result : res.values()) {
                cnt += result.getInfos().size();
            }
            return Integer.toString(cnt);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public long getTxTimeoutOnPartitionMapExchange() {
        return this.ctx.config().getTransactionConfiguration().getTxTimeoutOnPartitionMapExchange();
    }

    @Override
    public void setTxTimeoutOnPartitionMapExchange(long timeout) {
        try {
            this.ctx.grid().context().cache().setTxTimeoutOnPartitionMapExchange(timeout);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean getTxOwnerDumpRequestsAllowed() {
        return this.ctx.cache().context().tm().txOwnerDumpRequestsAllowed();
    }

    @Override
    public void setTxOwnerDumpRequestsAllowed(boolean allowed) {
        this.ctx.cache().setTxOwnerDumpRequestsAllowed(allowed);
    }

    @Override
    public long getLongTransactionTimeDumpThreshold() {
        return this.ctx.cache().context().tm().longTransactionTimeDumpThreshold();
    }

    @Override
    public void setLongTransactionTimeDumpThreshold(long threshold) {
        this.ctx.cache().longTransactionTimeDumpThreshold(threshold);
    }

    @Override
    public double getTransactionTimeDumpSamplesCoefficient() {
        return this.ctx.cache().context().tm().transactionTimeDumpSamplesCoefficient();
    }

    @Override
    public void setTransactionTimeDumpSamplesCoefficient(double coefficient) {
        this.ctx.cache().transactionTimeDumpSamplesCoefficient(coefficient);
    }

    @Override
    public int getTransactionTimeDumpSamplesPerSecondLimit() {
        return this.ctx.cache().context().tm().transactionTimeDumpSamplesPerSecondLimit();
    }

    @Override
    public void setTransactionTimeDumpSamplesPerSecondLimit(int limit) {
        this.ctx.cache().longTransactionTimeDumpSamplesPerSecondLimit(limit);
    }

    public String toString() {
        return S.toString(TransactionsMXBeanImpl.class, this);
    }
}

