/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.streams;

import org.apache.ignite.internal.util.typedef.internal.U;

public class BinaryMemoryAllocatorChunk {
    private static final Long CHECK_FREQ = Long.getLong("IGNITE_MARSHAL_BUFFERS_RECHECK", 10000L);
    private byte[] data;
    private int maxMsgSize;
    private long lastCheckNanos = System.nanoTime();
    private boolean acquired;

    public byte[] allocate(int size) {
        if (this.acquired) {
            return new byte[size];
        }
        this.acquired = true;
        if (this.data == null || size > this.data.length) {
            this.data = new byte[size];
        }
        return this.data;
    }

    public byte[] reallocate(byte[] data, int size) {
        byte[] newData = new byte[size];
        if (this.data == data) {
            this.data = newData;
        }
        System.arraycopy(data, 0, newData, 0, data.length);
        return newData;
    }

    public void release(byte[] data, int maxMsgSize) {
        if (this.data != data) {
            return;
        }
        if (maxMsgSize > this.maxMsgSize) {
            this.maxMsgSize = maxMsgSize;
        }
        this.acquired = false;
        long nowNanos = System.nanoTime();
        if (U.nanosToMillis(nowNanos - this.lastCheckNanos) >= CHECK_FREQ) {
            int halfSize = data.length >> 1;
            if (this.maxMsgSize < halfSize) {
                this.data = new byte[halfSize];
            }
            this.lastCheckNanos = nowNanos;
        }
    }

    public boolean isAcquired() {
        return this.acquired;
    }
}

