/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.cache.configuration.Factory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.client.ClientAuthenticationException;
import org.apache.ignite.client.ClientAuthorizationException;
import org.apache.ignite.client.ClientConnectionException;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.client.SslProtocol;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.streams.BinaryHeapInputStream;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.binary.streams.BinaryOutputStream;
import org.apache.ignite.internal.client.thin.ClientChannel;
import org.apache.ignite.internal.client.thin.ClientChannelConfiguration;
import org.apache.ignite.internal.client.thin.ClientError;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientProtocolError;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.PayloadInputChannel;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ProtocolVersion;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.jetbrains.annotations.Nullable;

class TcpClientChannel
implements ClientChannel {
    private static final Collection<ProtocolVersion> supportedVers = Arrays.asList(ProtocolVersion.V1_6_0, ProtocolVersion.V1_5_0, ProtocolVersion.V1_4_0, ProtocolVersion.V1_2_0, ProtocolVersion.V1_1_0, ProtocolVersion.V1_0_0);
    private static final long PAYLOAD_WAIT_TIMEOUT = 10L;
    private ProtocolVersion ver = ProtocolVersion.CURRENT_VER;
    private UUID srvNodeId;
    private AffinityTopologyVersion srvTopVer;
    private final Socket sock;
    private final OutputStream out;
    private final ByteCountingDataInput dataInput;
    private final AtomicLong reqId = new AtomicLong(1L);
    private final Lock sndLock = new ReentrantLock();
    private final Lock rcvLock = new ReentrantLock();
    private final Map<Long, ClientRequestFuture> pendingReqs = new ConcurrentHashMap<Long, ClientRequestFuture>();
    private final Collection<Consumer<ClientChannel>> topChangeLsnrs = new CopyOnWriteArrayList<Consumer<ClientChannel>>();

    TcpClientChannel(ClientChannelConfiguration cfg) throws ClientConnectionException, ClientAuthenticationException {
        TcpClientChannel.validateConfiguration(cfg);
        try {
            this.sock = TcpClientChannel.createSocket(cfg);
            this.out = this.sock.getOutputStream();
            this.dataInput = new ByteCountingDataInput(this.sock.getInputStream());
        }
        catch (IOException e) {
            throw this.handleIOError("addr=" + cfg.getAddress(), e);
        }
        this.handshake(cfg.getUserName(), cfg.getUserPassword());
    }

    @Override
    public void close() throws Exception {
        this.dataInput.close();
        this.out.close();
        this.sock.close();
        for (ClientRequestFuture pendingReq : this.pendingReqs.values()) {
            pendingReq.onDone(new ClientConnectionException("Channel is closed"));
        }
    }

    @Override
    public <T> T service(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter, Function<PayloadInputChannel, T> payloadReader) throws ClientConnectionException, ClientAuthorizationException {
        long id = this.send(op, payloadWriter);
        return this.receive(id, payloadReader);
    }

    private long send(ClientOperation op, Consumer<PayloadOutputChannel> payloadWriter) throws ClientConnectionException {
        long id = this.reqId.getAndIncrement();
        this.sndLock.lock();
        try (PayloadOutputChannel payloadCh = new PayloadOutputChannel(this);){
            this.pendingReqs.put(id, new ClientRequestFuture());
            BinaryOutputStream req = payloadCh.out();
            req.writeInt(0);
            req.writeShort(op.code());
            req.writeLong(id);
            if (payloadWriter != null) {
                payloadWriter.accept(payloadCh);
            }
            req.writeInt(0, req.position() - 4);
            this.write(req.array(), req.position());
        }
        catch (Throwable t) {
            this.pendingReqs.remove(id);
            throw t;
        }
        finally {
            this.sndLock.unlock();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T receive(long reqId, Function<PayloadInputChannel, T> payloadReader) throws ClientConnectionException, ClientAuthorizationException {
        ClientRequestFuture pendingReq = this.pendingReqs.get(reqId);
        assert (pendingReq != null) : "Pending request future not found for request " + reqId;
        while (true) {
            byte[] payload2;
            block19: {
                T t;
                if (this.rcvLock.tryLock()) {
                    try {
                        if (!pendingReq.isDone()) {
                            this.processNextResponse();
                        }
                    }
                    finally {
                        this.rcvLock.unlock();
                    }
                }
                try {
                    payload2 = (byte[])pendingReq.get(10L);
                    if (payload2 != null && payloadReader != null) break block19;
                    t = null;
                }
                catch (IgniteFutureTimeoutCheckedException payload2) {
                    try {
                        continue;
                    }
                    catch (IgniteCheckedException e) {
                        if (e.getCause() instanceof ClientError) {
                            throw (ClientError)e.getCause();
                        }
                        if (e.getCause() instanceof ClientException) {
                            throw (ClientException)e.getCause();
                        }
                        throw new ClientException(e.getMessage(), e);
                    }
                }
                return t;
            }
            T t = payloadReader.apply(new PayloadInputChannel(this, payload2));
            return t;
        }
        finally {
            this.pendingReqs.remove(reqId);
        }
    }

    private void processNextResponse() throws ClientProtocolError, ClientConnectionException {
        int resSize = this.dataInput.readInt();
        if (resSize <= 0) {
            throw new ClientProtocolError(String.format("Invalid response size: %s", resSize));
        }
        long bytesReadOnStartReq = this.dataInput.totalBytesRead();
        long resId = this.dataInput.readLong();
        ClientRequestFuture pendingReq = this.pendingReqs.get(resId);
        if (pendingReq == null) {
            throw new ClientProtocolError(String.format("Unexpected response ID [%s]", resId));
        }
        int status = 0;
        if (this.ver.compareTo(ProtocolVersion.V1_4_0) >= 0) {
            short flags = this.dataInput.readShort();
            if ((flags & 2) != 0) {
                long topVer = this.dataInput.readLong();
                int minorTopVer = this.dataInput.readInt();
                this.srvTopVer = new AffinityTopologyVersion(topVer, minorTopVer);
                for (Consumer<ClientChannel> lsnr : this.topChangeLsnrs) {
                    lsnr.accept(this);
                }
            }
            if ((flags & 1) != 0) {
                status = this.dataInput.readInt();
            }
        } else {
            status = this.dataInput.readInt();
        }
        int hdrSize = (int)(this.dataInput.totalBytesRead() - bytesReadOnStartReq);
        if (status == 0) {
            if (resSize <= hdrSize) {
                pendingReq.onDone();
            } else {
                pendingReq.onDone(this.dataInput.read(resSize - hdrSize));
            }
        } else {
            BinaryHeapInputStream resIn = new BinaryHeapInputStream(this.dataInput.read(resSize - hdrSize));
            String err = new BinaryReaderExImpl(null, resIn, null, true).readString();
            switch (status) {
                case 1012: {
                    pendingReq.onDone(new ClientAuthorizationException());
                }
            }
            pendingReq.onDone(new ClientServerError(err, status, resId));
        }
    }

    @Override
    public ProtocolVersion serverVersion() {
        return this.ver;
    }

    @Override
    public UUID serverNodeId() {
        return this.srvNodeId;
    }

    @Override
    public AffinityTopologyVersion serverTopologyVersion() {
        return this.srvTopVer;
    }

    @Override
    public void addTopologyChangeListener(Consumer<ClientChannel> lsnr) {
        this.topChangeLsnrs.add(lsnr);
    }

    private static void validateConfiguration(ClientChannelConfiguration cfg) {
        String error = null;
        InetSocketAddress addr = cfg.getAddress();
        if (addr == null) {
            error = "At least one Ignite server node must be specified in the Ignite client configuration";
        } else if (addr.getPort() < 1024 || addr.getPort() > 49151) {
            error = String.format("Ignite client port %s is out of valid ports range 1024...49151", addr.getPort());
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    private static Socket createSocket(ClientChannelConfiguration cfg) throws IOException {
        Socket sock = cfg.getSslMode() == SslMode.REQUIRED ? new ClientSslSocketFactory(cfg).create() : new Socket(cfg.getAddress().getHostName(), cfg.getAddress().getPort());
        sock.setTcpNoDelay(cfg.isTcpNoDelay());
        if (cfg.getTimeout() > 0) {
            sock.setSoTimeout(cfg.getTimeout());
        }
        if (cfg.getSendBufferSize() > 0) {
            sock.setSendBufferSize(cfg.getSendBufferSize());
        }
        if (cfg.getReceiveBufferSize() > 0) {
            sock.setReceiveBufferSize(cfg.getReceiveBufferSize());
        }
        return sock;
    }

    /*
     * Exception decompiling
     */
    private static byte[] marshalString(String s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handshake(String user, String pwd) throws ClientConnectionException, ClientAuthenticationException {
        this.handshakeReq(user, pwd);
        this.handshakeRes(user, pwd);
    }

    private void handshakeReq(String user, String pwd) throws ClientConnectionException {
        try (BinaryHeapOutputStream req = new BinaryHeapOutputStream(32);){
            req.writeInt(0);
            req.writeByte((byte)1);
            req.writeShort(this.ver.major());
            req.writeShort(this.ver.minor());
            req.writeShort(this.ver.patch());
            req.writeByte((byte)2);
            if (this.ver.compareTo(ProtocolVersion.V1_1_0) >= 0 && user != null && !user.isEmpty()) {
                req.writeByteArray(TcpClientChannel.marshalString(user));
                req.writeByteArray(TcpClientChannel.marshalString(pwd));
            }
            req.writeInt(0, req.position() - 4);
            this.write(req.array(), req.position());
        }
    }

    private void handshakeRes(String user, String pwd) throws ClientConnectionException, ClientAuthenticationException {
        int resSize = this.dataInput.readInt();
        if (resSize <= 0) {
            throw new ClientProtocolError(String.format("Invalid handshake response size: %s", resSize));
        }
        BinaryHeapInputStream res = new BinaryHeapInputStream(this.dataInput.read(resSize));
        try (BinaryReaderExImpl r = new BinaryReaderExImpl(null, res, null, true);){
            if (res.readBoolean()) {
                if (this.ver.compareTo(ProtocolVersion.V1_4_0) >= 0) {
                    this.srvNodeId = r.readUuid();
                }
            } else {
                ProtocolVersion srvVer = new ProtocolVersion(res.readShort(), res.readShort(), res.readShort());
                String err = r.readString();
                int errCode = 1;
                if (res.remaining() > 0) {
                    errCode = r.readInt();
                }
                if (errCode == 2000) {
                    throw new ClientAuthenticationException(err);
                }
                if (this.ver.equals(srvVer)) {
                    throw new ClientProtocolError(err);
                }
                if (!supportedVers.contains(srvVer) || srvVer.compareTo(ProtocolVersion.V1_1_0) < 0 && user != null && !user.isEmpty()) {
                    throw new ClientProtocolError(String.format("Protocol version mismatch: client %s / server %s. Server details: %s", this.ver, srvVer, err));
                }
                this.ver = srvVer;
                this.handshake(user, pwd);
            }
        }
        catch (IOException e) {
            throw this.handleIOError(e);
        }
    }

    private void write(byte[] bytes, int len) throws ClientConnectionException {
        try {
            this.out.write(bytes, 0, len);
            this.out.flush();
        }
        catch (IOException e) {
            throw this.handleIOError(e);
        }
    }

    private ClientException handleIOError(@Nullable IOException ex) {
        return this.handleIOError("sock=" + this.sock, ex);
    }

    private ClientException handleIOError(String chInfo, @Nullable IOException ex) {
        return new ClientConnectionException("Ignite cluster is unavailable [" + chInfo + ']', ex);
    }

    private static class ClientSslSocketFactory {
        private static TrustManager ignoreErrorsTrustMgr = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }
        };
        private final ClientChannelConfiguration cfg;

        ClientSslSocketFactory(ClientChannelConfiguration cfg) {
            this.cfg = cfg;
        }

        SSLSocket create() throws IOException {
            InetSocketAddress addr = this.cfg.getAddress();
            SSLSocket sock = (SSLSocket)ClientSslSocketFactory.getSslSocketFactory(this.cfg).createSocket(addr.getHostName(), addr.getPort());
            sock.setUseClientMode(true);
            sock.startHandshake();
            return sock;
        }

        private static SSLSocketFactory getSslSocketFactory(ClientChannelConfiguration cfg) {
            TrustManager[] trustManagerArray;
            Factory<SSLContext> sslCtxFactory = cfg.getSslContextFactory();
            if (sslCtxFactory != null) {
                try {
                    return sslCtxFactory.create().getSocketFactory();
                }
                catch (Exception e) {
                    throw new ClientError("SSL Context Factory failed", e);
                }
            }
            BiFunction<String, String, String> or = (val, dflt) -> val == null || val.isEmpty() ? dflt : val;
            String keyStore = or.apply(cfg.getSslClientCertificateKeyStorePath(), System.getProperty("javax.net.ssl.keyStore"));
            String keyStoreType = or.apply(cfg.getSslClientCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.keyStoreType"), "JKS"));
            String keyStorePwd = or.apply(cfg.getSslClientCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.keyStorePassword"));
            String trustStore = or.apply(cfg.getSslTrustCertificateKeyStorePath(), System.getProperty("javax.net.ssl.trustStore"));
            String trustStoreType = or.apply(cfg.getSslTrustCertificateKeyStoreType(), or.apply(System.getProperty("javax.net.ssl.trustStoreType"), "JKS"));
            String trustStorePwd = or.apply(cfg.getSslTrustCertificateKeyStorePassword(), System.getProperty("javax.net.ssl.trustStorePassword"));
            String algorithm = or.apply(cfg.getSslKeyAlgorithm(), "SunX509");
            String proto = ClientSslSocketFactory.toString(cfg.getSslProtocol());
            if (Stream.of(keyStore, keyStorePwd, keyStoreType, trustStore, trustStorePwd, trustStoreType).allMatch(s -> s == null || s.isEmpty())) {
                try {
                    return SSLContext.getDefault().getSocketFactory();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ClientError("Default SSL context cryptographic algorithm is not available", e);
                }
            }
            KeyManager[] keyManagers = ClientSslSocketFactory.getKeyManagers(algorithm, keyStore, keyStoreType, keyStorePwd);
            if (cfg.isSslTrustAll()) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = ignoreErrorsTrustMgr;
            } else {
                trustManagerArray = ClientSslSocketFactory.getTrustManagers(algorithm, trustStore, trustStoreType, trustStorePwd);
            }
            TrustManager[] trustManagers = trustManagerArray;
            try {
                SSLContext sslCtx = SSLContext.getInstance(proto);
                sslCtx.init(keyManagers, trustManagers, null);
                return sslCtx.getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("SSL context cryptographic algorithm is not available", e);
            }
            catch (KeyManagementException e) {
                throw new ClientError("Failed to create SSL Context", e);
            }
        }

        private static String toString(SslProtocol proto) {
            switch (proto) {
                case TLSv1_1: {
                    return "TLSv1.1";
                }
                case TLSv1_2: {
                    return "TLSv1.2";
                }
            }
            return proto.toString();
        }

        private static KeyManager[] getKeyManagers(String algorithm, String keyStore, String keyStoreType, String keyStorePwd) {
            KeyManagerFactory keyMgrFactory;
            try {
                keyMgrFactory = KeyManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Key manager cryptographic algorithm is not available", e);
            }
            Predicate<String> empty = s -> s == null || s.isEmpty();
            if (!empty.test(keyStore) && !empty.test(keyStoreType)) {
                char[] pwd = keyStorePwd == null ? new char[]{} : keyStorePwd.toCharArray();
                KeyStore store = ClientSslSocketFactory.loadKeyStore("Client", keyStore, keyStoreType, pwd);
                try {
                    keyMgrFactory.init(store, pwd);
                }
                catch (UnrecoverableKeyException e) {
                    throw new ClientError("Could not recover key store key", e);
                }
                catch (KeyStoreException e) {
                    throw new ClientError(String.format("Client key store provider of type [%s] is not available", keyStoreType), e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ClientError("Client key store integrity check algorithm is not available", e);
                }
            }
            return keyMgrFactory.getKeyManagers();
        }

        private static TrustManager[] getTrustManagers(String algorithm, String trustStore, String trustStoreType, String trustStorePwd) {
            TrustManagerFactory trustMgrFactory;
            try {
                trustMgrFactory = TrustManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError("Trust manager cryptographic algorithm is not available", e);
            }
            Predicate<String> empty = s -> s == null || s.isEmpty();
            if (!empty.test(trustStore) && !empty.test(trustStoreType)) {
                char[] pwd = trustStorePwd == null ? new char[]{} : trustStorePwd.toCharArray();
                KeyStore store = ClientSslSocketFactory.loadKeyStore("Trust", trustStore, trustStoreType, pwd);
                try {
                    trustMgrFactory.init(store);
                }
                catch (KeyStoreException e) {
                    throw new ClientError(String.format("Trust key store provider of type [%s] is not available", trustStoreType), e);
                }
            }
            return trustMgrFactory.getTrustManagers();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static KeyStore loadKeyStore(String lb, String path, String type, char[] pwd) {
            KeyStore store;
            try {
                store = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                throw new ClientError(String.format("%s key store provider of type [%s] is not available", lb, type), e);
            }
            try (FileInputStream in = new FileInputStream(new File(path));){
                store.load(in, pwd);
                KeyStore keyStore = store;
                return keyStore;
            }
            catch (FileNotFoundException e) {
                throw new ClientError(String.format("%s key store file [%s] does not exist", lb, path), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ClientError(String.format("%s key store integrity check algorithm is not available", lb), e);
            }
            catch (CertificateException e) {
                throw new ClientError(String.format("Could not load certificate from %s key store", lb), e);
            }
            catch (IOException e) {
                throw new ClientError(String.format("Could not read %s key store", lb), e);
            }
        }
    }

    private static class ClientRequestFuture
    extends GridFutureAdapter<byte[]> {
        private ClientRequestFuture() {
        }
    }

    private class ByteCountingDataInput {
        private final InputStream in;
        private long totalBytesRead;
        private byte[] tmpBuf = new byte[8];

        public ByteCountingDataInput(InputStream in) {
            this.in = in;
        }

        private void read(byte[] bytes, int len) throws ClientConnectionException {
            int readBytesNum;
            int bytesNum;
            for (readBytesNum = 0; readBytesNum < len; readBytesNum += bytesNum) {
                try {
                    bytesNum = this.in.read(bytes, readBytesNum, len - readBytesNum);
                }
                catch (IOException e) {
                    throw TcpClientChannel.this.handleIOError(e);
                }
                if (bytesNum >= 0) continue;
                throw TcpClientChannel.this.handleIOError(null);
            }
            this.totalBytesRead += (long)readBytesNum;
        }

        public byte[] read(int len) throws ClientConnectionException {
            byte[] bytes = new byte[len];
            this.read(bytes, len);
            return bytes;
        }

        public long readLong() throws ClientConnectionException {
            this.read(this.tmpBuf, 8);
            return BinaryPrimitives.readLong(this.tmpBuf, 0);
        }

        public int readInt() throws ClientConnectionException {
            this.read(this.tmpBuf, 4);
            return BinaryPrimitives.readInt(this.tmpBuf, 0);
        }

        public short readShort() throws ClientConnectionException {
            this.read(this.tmpBuf, 2);
            return BinaryPrimitives.readShort(this.tmpBuf, 0);
        }

        public long totalBytesRead() {
            return this.totalBytesRead;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

