/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandList;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.misc.VisorClusterNode;
import org.apache.ignite.internal.visor.misc.VisorWalTask;
import org.apache.ignite.internal.visor.misc.VisorWalTaskArg;
import org.apache.ignite.internal.visor.misc.VisorWalTaskOperation;
import org.apache.ignite.internal.visor.misc.VisorWalTaskResult;

public class WalCommands
implements Command<T2<String, String>> {
    static final String WAL_PRINT = "print";
    static final String WAL_DELETE = "delete";
    private Logger logger;
    private String walAct;
    private String walArgs;

    @Override
    public void printUsage(Logger logger) {
        if (!this.enableExperimental()) {
            return;
        }
        Command.usage(logger, "Print absolute paths of unused archived wal segments on each node:", CommandList.WAL, WAL_PRINT, "[consistentId1,consistentId2,....,consistentIdN]");
        Command.usage(logger, "Delete unused archived wal segments on each node:", CommandList.WAL, WAL_DELETE, "[consistentId1,consistentId2,....,consistentIdN]", CommandLogger.optional("--yes"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        if (this.enableExperimental()) {
            this.logger = logger;
            try (GridClient client = Command.startClient(clientCfg);){
                switch (this.walAct) {
                    case "delete": {
                        this.deleteUnusedWalSegments(client, this.walArgs, clientCfg);
                        return null;
                    }
                    default: {
                        this.printUnusedWalSegments(client, this.walArgs, clientCfg);
                        return null;
                    }
                }
            }
        } else {
            logger.warning(String.format("For use experimental command add %s=true to JVM_OPTS in %s", "IGNITE_ENABLE_EXPERIMENTAL_COMMAND", "control.(sh|bat)"));
        }
        return null;
    }

    @Override
    public String confirmationPrompt() {
        if (WAL_DELETE.equals(this.walAct)) {
            return "Warning: the command will delete unused WAL segments.";
        }
        return null;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        String str = argIter.nextArg("Expected arguments for " + CommandList.WAL.text());
        String walAct = str.toLowerCase();
        if (WAL_PRINT.equals(walAct) || WAL_DELETE.equals(walAct)) {
            String walArgs;
            str = argIter.peekNextArg();
            String string = walArgs = str != null && !CommandArgIterator.isCommandOrOption(str) ? argIter.nextArg("Unexpected argument for " + CommandList.WAL.text() + ": " + walAct) : "";
            if (this.enableExperimental()) {
                this.walAct = walAct;
                this.walArgs = walArgs;
            }
        } else {
            throw new IllegalArgumentException("Unexpected action " + walAct + " for " + CommandList.WAL.text());
        }
    }

    @Override
    public T2<String, String> arg() {
        return new T2<String, String>(this.walAct, this.walArgs);
    }

    private void deleteUnusedWalSegments(GridClient client, String walArgs, GridClientConfiguration clientCfg) throws Exception {
        VisorWalTaskResult res = (VisorWalTaskResult)TaskExecutor.executeTask(client, VisorWalTask.class, this.walArg(VisorWalTaskOperation.DELETE_UNUSED_WAL_SEGMENTS, walArgs), clientCfg);
        this.printDeleteWalSegments0(res);
    }

    private void printUnusedWalSegments(GridClient client, String walArgs, GridClientConfiguration clientCfg) throws Exception {
        VisorWalTaskResult res = (VisorWalTaskResult)TaskExecutor.executeTask(client, VisorWalTask.class, this.walArg(VisorWalTaskOperation.PRINT_UNUSED_WAL_SEGMENTS, walArgs), clientCfg);
        this.printUnusedWalSegments0(res);
    }

    private VisorWalTaskArg walArg(VisorWalTaskOperation op, String s) {
        ArrayList<String> consistentIds = null;
        if (!F.isEmpty(s)) {
            consistentIds = new ArrayList<String>();
            for (String consistentId : s.split(",")) {
                consistentIds.add(consistentId.trim());
            }
        }
        switch (op) {
            case DELETE_UNUSED_WAL_SEGMENTS: 
            case PRINT_UNUSED_WAL_SEGMENTS: {
                return new VisorWalTaskArg(op, consistentIds);
            }
        }
        return new VisorWalTaskArg(VisorWalTaskOperation.PRINT_UNUSED_WAL_SEGMENTS, consistentIds);
    }

    private void printUnusedWalSegments0(VisorWalTaskResult taskRes) {
        VisorClusterNode node;
        this.logger.info("Unused wal segments per node:");
        this.logger.info("");
        Map<String, Collection<String>> res = taskRes.results();
        Map<String, Exception> failRes = taskRes.exceptions();
        Map<String, VisorClusterNode> nodesInfo = taskRes.getNodesInfo();
        for (Map.Entry<String, Collection<String>> entry : res.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.logger.info("Node=" + node.getConsistentId());
            this.logger.info("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            for (String fileName : entry.getValue()) {
                this.logger.info("  " + fileName);
            }
            this.logger.info("");
        }
        for (Map.Entry<String, Object> entry : failRes.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.logger.info("Node=" + node.getConsistentId());
            this.logger.info("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            this.logger.info("  failed with error: " + ((Exception)entry.getValue()).getMessage());
            this.logger.info("");
        }
    }

    private void printDeleteWalSegments0(VisorWalTaskResult taskRes) {
        VisorClusterNode node;
        this.logger.info("WAL segments deleted for nodes:");
        this.logger.info("");
        Map<String, Collection<String>> res = taskRes.results();
        Map<String, Exception> errors = taskRes.exceptions();
        Map<String, VisorClusterNode> nodesInfo = taskRes.getNodesInfo();
        for (Map.Entry<String, Collection<String>> entry : res.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.logger.info("Node=" + node.getConsistentId());
            this.logger.info("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            this.logger.info("");
        }
        for (Map.Entry<String, Object> entry : errors.entrySet()) {
            node = nodesInfo.get(entry.getKey());
            this.logger.info("Node=" + node.getConsistentId());
            this.logger.info("    addresses " + U.addressesAsString(node.getAddresses(), node.getHostNames()));
            this.logger.info("  failed with error: " + ((Exception)entry.getValue()).getMessage());
            this.logger.info("");
        }
    }

    @Override
    public String name() {
        return CommandList.WAL.toCommandName();
    }

    private boolean enableExperimental() {
        return IgniteSystemProperties.getBoolean("IGNITE_ENABLE_EXPERIMENTAL_COMMAND", false);
    }
}

