/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.Command;
import org.apache.ignite.internal.commandline.CommandArgIterator;
import org.apache.ignite.internal.commandline.CommandLogger;
import org.apache.ignite.internal.commandline.TaskExecutor;
import org.apache.ignite.internal.commandline.argument.CommandArgUtils;
import org.apache.ignite.internal.commandline.cache.CacheCommands;
import org.apache.ignite.internal.commandline.cache.CacheSubcommands;
import org.apache.ignite.internal.commandline.cache.argument.IdleVerifyCommandArg;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyResultV2;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecord;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.cache.verify.VerifyBackupPartitionsTaskV2;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.visor.verify.CacheFilterEnum;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTask;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyDumpTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTask;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskArg;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskResult;
import org.apache.ignite.internal.visor.verify.VisorIdleVerifyTaskV2;
import org.apache.ignite.lang.IgniteProductVersion;

public class IdleVerify
implements Command<Arguments> {
    private Arguments args;

    @Override
    public void printUsage(Logger logger) {
        String CACHES = "cacheName1,...,cacheNameN";
        String description = "Verify counters and hash sums of primary and backup partitions for the specified caches/cache groups on an idle cluster and print out the differences, if any. Cache filtering options configure the set of caches that will be processed by idle_verify command. Default value for the set of cache names (or cache group names) is all cache groups. Default value for " + IdleVerifyCommandArg.EXCLUDE_CACHES + " is empty set. Default value for " + IdleVerifyCommandArg.CACHE_FILTER + " is no filtering. Therefore, the set of all caches is sequently filtered by cache name regexps, by cache type and after all by exclude regexps.";
        CacheCommands.usageCache(logger, CacheSubcommands.IDLE_VERIFY, description, Collections.singletonMap(IdleVerifyCommandArg.CHECK_CRC.toString(), "check the CRC-sum of pages stored on disk before verifying data consistency in partitions between primary and backup nodes."), CommandLogger.optional(IdleVerifyCommandArg.DUMP), CommandLogger.optional(IdleVerifyCommandArg.SKIP_ZEROS), CommandLogger.optional(IdleVerifyCommandArg.CHECK_CRC), CommandLogger.optional(IdleVerifyCommandArg.EXCLUDE_CACHES, CACHES), CommandLogger.optional(IdleVerifyCommandArg.CACHE_FILTER, CommandLogger.or((Object[])CacheFilterEnum.values())), CommandLogger.optional(CACHES));
    }

    @Override
    public Arguments arg() {
        return this.args;
    }

    @Override
    public Object execute(GridClientConfiguration clientCfg, Logger logger) throws Exception {
        try (GridClient client = Command.startClient(clientCfg);){
            Collection<GridClientNode> nodes = client.compute().nodes(GridClientNode::connectable);
            boolean idleVerifyV2 = true;
            for (GridClientNode node : nodes) {
                String nodeVerStr = (String)node.attribute("org.apache.ignite.build.ver");
                IgniteProductVersion nodeVer = IgniteProductVersion.fromString(nodeVerStr);
                if (nodeVer.compareTo(VerifyBackupPartitionsTaskV2.V2_SINCE_VER) >= 0) continue;
                idleVerifyV2 = false;
                break;
            }
            if (this.args.dump()) {
                this.cacheIdleVerifyDump(client, clientCfg, logger);
            } else if (idleVerifyV2) {
                this.cacheIdleVerifyV2(client, clientCfg);
            } else {
                this.legacyCacheIdleVerify(client, clientCfg, logger);
            }
        }
        return null;
    }

    @Override
    public void parseArguments(CommandArgIterator argIter) {
        Set<String> cacheNames = null;
        boolean dump = false;
        boolean skipZeros = false;
        boolean idleCheckCrc = false;
        CacheFilterEnum cacheFilterEnum = CacheFilterEnum.DEFAULT;
        Set<String> excludeCaches = null;
        int idleVerifyArgsCnt = 5;
        while (argIter.hasNextSubArg() && idleVerifyArgsCnt-- > 0) {
            String nextArg = argIter.nextArg("");
            IdleVerifyCommandArg arg = CommandArgUtils.of(nextArg, IdleVerifyCommandArg.class);
            if (arg == null) {
                cacheNames = argIter.parseStringSet(nextArg);
                this.validateRegexes(cacheNames);
                continue;
            }
            switch (arg) {
                case DUMP: {
                    dump = true;
                    break;
                }
                case SKIP_ZEROS: {
                    skipZeros = true;
                    break;
                }
                case CHECK_CRC: {
                    idleCheckCrc = true;
                    break;
                }
                case CACHE_FILTER: {
                    String filter = argIter.nextArg("The cache filter should be specified. The following values can be used: " + Arrays.toString((Object[])CacheFilterEnum.values()) + '.');
                    cacheFilterEnum = CacheFilterEnum.valueOf(filter.toUpperCase());
                    break;
                }
                case EXCLUDE_CACHES: {
                    excludeCaches = argIter.nextStringSet("caches, which will be excluded.");
                    this.validateRegexes(excludeCaches);
                }
            }
        }
        this.args = new Arguments(cacheNames, excludeCaches, dump, skipZeros, idleCheckCrc, cacheFilterEnum);
    }

    private void validateRegexes(Set<String> string) {
        string.forEach(s -> {
            try {
                Pattern.compile(s);
            }
            catch (PatternSyntaxException e) {
                throw new IgniteException(String.format("Invalid cache name regexp '%s': %s", s, e.getMessage()));
            }
        });
    }

    private void cacheIdleVerifyDump(GridClient client, GridClientConfiguration clientCfg, Logger logger) throws GridClientException {
        VisorIdleVerifyDumpTaskArg arg = new VisorIdleVerifyDumpTaskArg(this.args.caches(), this.args.excludeCaches(), this.args.isSkipZeros(), this.args.getCacheFilterEnum(), this.args.idleCheckCrc());
        String path = (String)TaskExecutor.executeTask(client, VisorIdleVerifyDumpTask.class, arg, clientCfg);
        logger.info("VisorIdleVerifyDumpTask successfully written output to '" + path + "'");
        IdleVerify.logParsedArgs(arg, logger::info);
    }

    private void cacheIdleVerifyV2(GridClient client, GridClientConfiguration clientCfg) throws GridClientException {
        VisorIdleVerifyTaskArg taskArg = new VisorIdleVerifyTaskArg(this.args.caches(), this.args.excludeCaches(), this.args.isSkipZeros(), this.args.getCacheFilterEnum(), this.args.idleCheckCrc());
        IdleVerifyResultV2 res = (IdleVerifyResultV2)TaskExecutor.executeTask(client, VisorIdleVerifyTaskV2.class, taskArg, clientCfg);
        IdleVerify.logParsedArgs(taskArg, System.out::print);
        res.print(System.out::print);
    }

    public static void logParsedArgs(VisorIdleVerifyTaskArg args, Consumer<String> logConsumer) {
        SB options = new SB("idle_verify task was executed with the following args: ");
        options.a("caches=[").a(args.caches() == null ? "" : String.join((CharSequence)", ", args.caches())).a("], excluded=[").a(args.excludeCaches() == null ? "" : String.join((CharSequence)", ", args.excludeCaches())).a("]").a(", cacheFilter=[").a(args.cacheFilterEnum().toString()).a("]\n");
        logConsumer.accept(options.toString());
    }

    private void legacyCacheIdleVerify(GridClient client, GridClientConfiguration clientCfg, Logger logger) throws GridClientException {
        VisorIdleVerifyTaskResult res = (VisorIdleVerifyTaskResult)TaskExecutor.executeTask(client, VisorIdleVerifyTask.class, new VisorIdleVerifyTaskArg(this.args.caches(), this.args.excludeCaches(), this.args.isSkipZeros(), this.args.getCacheFilterEnum(), this.args.idleCheckCrc()), clientCfg);
        Map<PartitionKey, List<PartitionHashRecord>> conflicts = res.getConflicts();
        if (conflicts.isEmpty()) {
            logger.info("idle_verify check has finished, no conflicts have been found.");
            logger.info("");
        } else {
            logger.info("idle_verify check has finished, found " + conflicts.size() + " conflict partitions.");
            logger.info("");
            for (Map.Entry<PartitionKey, List<PartitionHashRecord>> entry : conflicts.entrySet()) {
                logger.info("Conflict partition: " + entry.getKey());
                logger.info("Partition instances: " + entry.getValue());
            }
        }
    }

    @Override
    public String name() {
        return CacheSubcommands.IDLE_VERIFY.text().toUpperCase();
    }

    public static class Arguments {
        private Set<String> caches;
        private Set<String> excludeCaches;
        private boolean dump;
        private boolean skipZeros;
        private boolean idleCheckCrc;
        private CacheFilterEnum cacheFilterEnum;

        public Arguments(Set<String> caches, Set<String> excludeCaches, boolean dump, boolean skipZeros, boolean idleCheckCrc, CacheFilterEnum cacheFilterEnum) {
            this.caches = caches;
            this.excludeCaches = excludeCaches;
            this.dump = dump;
            this.skipZeros = skipZeros;
            this.idleCheckCrc = idleCheckCrc;
            this.cacheFilterEnum = cacheFilterEnum;
        }

        public CacheFilterEnum getCacheFilterEnum() {
            return this.cacheFilterEnum;
        }

        public Set<String> caches() {
            return this.caches;
        }

        public Set<String> excludeCaches() {
            return this.excludeCaches;
        }

        public boolean dump() {
            return this.dump;
        }

        public boolean idleCheckCrc() {
            return this.idleCheckCrc;
        }

        public boolean isSkipZeros() {
            return this.skipZeros;
        }
    }
}

