/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.direct.state;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.ignite.internal.direct.state.DirectMessageStateItem;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteOutClosure;

public class DirectMessageState<T extends DirectMessageStateItem> {
    private static final int INIT_SIZE = 10;
    @GridToStringExclude
    private final IgniteOutClosure<T> factory;
    private T[] stack;
    private int pos;

    public DirectMessageState(Class<T> cls, IgniteOutClosure<T> factory) {
        this.factory = factory;
        this.stack = (DirectMessageStateItem[])Array.newInstance(cls, 10);
        this.stack[0] = (DirectMessageStateItem)factory.apply();
    }

    public T item() {
        return this.stack[this.pos];
    }

    public void forward() {
        ++this.pos;
        if (this.pos == this.stack.length) {
            T[] stack0 = this.stack;
            this.stack = (DirectMessageStateItem[])Array.newInstance(this.stack.getClass().getComponentType(), this.stack.length << 1);
            System.arraycopy(stack0, 0, this.stack, 0, stack0.length);
        }
        if (this.stack[this.pos] == null) {
            this.stack[this.pos] = (DirectMessageStateItem)this.factory.apply();
        }
    }

    public void backward(boolean reset) {
        if (reset) {
            this.stack[this.pos].reset();
        }
        --this.pos;
    }

    public void reset() {
        assert (this.pos == 0);
        this.stack[0].reset();
    }

    public String toString() {
        return S.toString(DirectMessageState.class, this, "stack", Arrays.toString(this.stack));
    }
}

