/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLPermission;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.jdbc.thin.AffinityCache;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.jdbc.thin.JdbcThinDatabaseMetadata;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPartitionAwarenessMappingGroup;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPartitionResultDescriptor;
import org.apache.ignite.internal.jdbc.thin.JdbcThinPreparedStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinStatement;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.internal.jdbc.thin.QualifiedSQLQuery;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcCachePartitionsResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcOrderedBatchExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQuery;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryCancelRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcQueryExecuteResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResponse;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResultWithIo;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcStatementType;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlSetStreamingCommand;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionClientContext;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteProductVersion;
import org.jetbrains.annotations.Nullable;

public class JdbcThinConnection
implements Connection {
    private static final Logger LOG = Logger.getLogger(JdbcThinConnection.class.getName());
    private static final int REQUEST_TIMEOUT_PERIOD = 1000;
    private static final String SET_NETWORK_TIMEOUT_PERM = "setNetworkTimeout";
    static final int NO_TIMEOUT = 0;
    private static final AtomicLong IDX_GEN = new AtomicLong();
    private final boolean partitionAwareness;
    private final Object stmtsMux = new Object();
    private String schema;
    private volatile boolean closed;
    private int txIsolation;
    private boolean autoCommit;
    private boolean readOnly;
    private volatile StreamState streamState;
    private int holdability;
    private JdbcThinDatabaseMetadata metadata;
    private final ConnectionProperties connProps;
    private volatile boolean connected;
    private final Set<JdbcThinStatement> stmts = Collections.newSetFromMap(new IdentityHashMap());
    private final Timer timer;
    private AffinityCache affinityCache;
    private volatile JdbcThinTcpIo singleIo;
    private final Map<UUID, JdbcThinTcpIo> ios = new ConcurrentHashMap<UUID, JdbcThinTcpIo>();
    private JdbcThinTcpIo[] iosArr;
    private int srvIdx;
    private Thread ownThread;
    private final Object mux = new Object();
    private volatile JdbcThinTcpIo txIo;
    private static final Random RND = new Random(System.currentTimeMillis());
    private int netTimeout;

    public JdbcThinConnection(ConnectionProperties connProps) throws SQLException {
        this.connProps = connProps;
        this.holdability = 1;
        this.autoCommit = true;
        this.txIsolation = 0;
        this.schema = JdbcUtils.normalizeSchema(connProps.getSchema());
        this.timer = new Timer("query-timeout-timer");
        this.partitionAwareness = connProps.isPartitionAwareness();
        this.ensureConnected();
    }

    private void ensureConnected() throws SQLException {
        if (this.connected) {
            return;
        }
        assert (!this.closed);
        assert (this.ios.isEmpty());
        assert (this.iosArr == null);
        HostAndPortRange[] srvs = this.connProps.getAddresses();
        if (this.partitionAwareness) {
            this.connectInAffinityAwarenessMode(srvs);
        } else {
            this.connectInCommonMode(srvs);
        }
    }

    boolean isStream() {
        return this.streamState != null;
    }

    void executeNative(String sql, SqlCommand cmd, JdbcThinStatement stmt) throws SQLException {
        if (cmd instanceof SqlSetStreamingCommand) {
            SqlSetStreamingCommand cmd0 = (SqlSetStreamingCommand)cmd;
            if (this.streamState != null) {
                this.streamState.close();
                this.streamState = null;
            }
            boolean newVal = ((SqlSetStreamingCommand)cmd).isTurnOn();
            this.ensureConnected();
            JdbcThinTcpIo cliIo = this.cliIo(null);
            if (newVal) {
                if (!cmd0.isOrdered() && !cliIo.isUnorderedStreamSupported()) {
                    throw new SQLException("Streaming without order doesn't supported by server [remoteNodeVer=" + cliIo.igniteVersion() + ']', "50000");
                }
                this.streamState = new StreamState((SqlSetStreamingCommand)cmd, cliIo);
                this.sendRequest(new JdbcQueryExecuteRequest(JdbcStatementType.ANY_STATEMENT_TYPE, this.schema, 1, 1, this.autoCommit, sql, null), stmt, cliIo);
                this.streamState.start();
            }
        } else {
            throw IgniteQueryErrorCode.createJdbcSqlException("Unsupported native statement: " + sql, 1002);
        }
    }

    void addBatch(String sql, List<Object> args) throws SQLException {
        assert (this.isStream());
        this.streamState.addBatch(sql, args);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        JdbcThinStatement stmt = new JdbcThinStatement(this, resSetHoldability, this.schema);
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resSetType, resSetConcurrency, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        this.checkCursorOptions(resSetType, resSetConcurrency);
        if (sql == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        JdbcThinPreparedStatement stmt = new JdbcThinPreparedStatement(this, sql, resSetHoldability, this.schema);
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.add(stmt);
        }
        return stmt;
    }

    private void checkCursorOptions(int resSetType, int resSetConcurrency) throws SQLException {
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported).");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureNotClosed();
        if (sql == null) {
            throw new SQLException("SQL string cannot be null.");
        }
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (autoCommit != this.autoCommit) {
            this.doCommit();
            this.autoCommit = autoCommit;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be committed explicitly in auto-commit mode.");
        }
        this.doCommit();
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Transaction cannot be rolled back explicitly in auto-commit mode.");
        }
        try (Statement s = this.createStatement();){
            s.execute("ROLLBACK");
        }
    }

    private void doCommit() throws SQLException {
        try (Statement s = this.createStatement();){
            s.execute("COMMIT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.streamState != null) {
            this.streamState.close();
            this.streamState = null;
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.clear();
        }
        Object err = null;
        this.closed = true;
        if (this.partitionAwareness) {
            for (JdbcThinTcpIo clioIo : this.ios.values()) {
                clioIo.close();
            }
            this.ios.clear();
            this.iosArr = null;
        } else if (this.singleIo != null) {
            this.singleIo.close();
        }
        this.timer.cancel();
        if (err != null) {
            throw err;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        if (this.metadata == null) {
            this.metadata = new JdbcThinDatabaseMetadata(this);
        }
        return this.metadata;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new SQLException("Invalid transaction isolation level.", "0700E");
            }
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        return this.txIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (holdability != 1 && holdability != 2) {
            throw new SQLException("Invalid result set holdability value.");
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        if (name == null) {
            throw new SQLException("Savepoint name cannot be null.");
        }
        if (this.autoCommit) {
            throw new SQLException("Savepoint cannot be set in auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Invalid savepoint.");
        }
        if (this.autoCommit) {
            throw new SQLException("Auto-commit mode.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        if (savepoint == null) {
            throw new SQLException("Savepoint cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Auto generated keys are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        return !this.closed;
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        if (this.closed) {
            throw new SQLClientInfoException("Connection is closed.", null);
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        if (typeName == null) {
            throw new SQLException("Type name cannot be null.");
        }
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(JdbcThinConnection.class);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureNotClosed();
        this.schema = JdbcUtils.normalizeSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureNotClosed();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw new SQLException("Executor cannot be null.");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        this.ensureNotClosed();
        if (ms < 0) {
            throw new SQLException("Network timeout cannot be negative.");
        }
        SecurityManager secMgr = System.getSecurityManager();
        if (secMgr != null) {
            secMgr.checkPermission(new SQLPermission(SET_NETWORK_TIMEOUT_PERM));
        }
        this.netTimeout = ms;
        if (this.partitionAwareness) {
            for (JdbcThinTcpIo clioIo : this.ios.values()) {
                clioIo.timeout(ms);
            }
        } else {
            this.singleIo.timeout(ms);
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureNotClosed();
        return this.netTimeout;
    }

    public void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.", "08003");
        }
    }

    IgniteProductVersion igniteVersion() {
        return this.cliIo(null).igniteVersion();
    }

    boolean autoCloseServerCursor() {
        return this.connProps.isAutoCloseServerCursor();
    }

    JdbcResultWithIo sendRequest(JdbcRequest req) throws SQLException {
        return this.sendRequest(req, null, null);
    }

    /*
     * Exception decompiling
     */
    JdbcResultWithIo sendRequest(JdbcRequest req, JdbcThinStatement stmt, @Nullable JdbcThinTcpIo stickyIo) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private List<UUID> calculateNodeIds(JdbcRequest req) throws IOException, SQLException {
        if (!this.partitionAwareness || !(req instanceof JdbcQueryExecuteRequest)) {
            return null;
        }
        JdbcQueryExecuteRequest qry = (JdbcQueryExecuteRequest)req;
        if (this.affinityCache == null) {
            qry.partitionResponseRequest(true);
            return null;
        }
        JdbcThinPartitionResultDescriptor partResDesc = this.affinityCache.partitionResult(new QualifiedSQLQuery(qry.schemaName(), qry.sqlQuery()));
        if (partResDesc == JdbcThinPartitionResultDescriptor.EMPTY_DESCRIPTOR) {
            return null;
        }
        if (partResDesc == null) {
            qry.partitionResponseRequest(true);
            return null;
        }
        Collection<Integer> parts = JdbcThinConnection.calculatePartitions(partResDesc, qry.arguments());
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        UUID[] cacheDistr = this.retrieveCacheDistribution(partResDesc.cacheId(), partResDesc.partitionResult().partitionsCount());
        if (parts.size() == 1) {
            return Collections.singletonList(cacheDistr[parts.iterator().next()]);
        }
        ArrayList<UUID> partitionAwarenessNodeIds = new ArrayList<UUID>();
        for (int part : parts) {
            partitionAwarenessNodeIds.add(cacheDistr[part]);
        }
        return partitionAwarenessNodeIds;
    }

    private UUID[] retrieveCacheDistribution(int cacheId, int partCnt) throws IOException {
        UUID[] cacheDistr = this.affinityCache.cacheDistribution(cacheId);
        if (cacheDistr != null) {
            return cacheDistr;
        }
        JdbcResponse res = this.cliIo(null).sendRequest(new JdbcCachePartitionsRequest(Collections.singleton(cacheId)), null);
        assert (res.status() == 0);
        AffinityTopologyVersion resAffinityVer = res.affinityVersion();
        if (this.affinityCache.version().compareTo(resAffinityVer) < 0) {
            this.affinityCache = new AffinityCache(resAffinityVer);
        } else if (this.affinityCache.version().compareTo(resAffinityVer) > 0) {
            return null;
        }
        List<JdbcThinPartitionAwarenessMappingGroup> mappings = ((JdbcCachePartitionsResult)res.response()).getMappings();
        assert (mappings.size() == 1);
        JdbcThinPartitionAwarenessMappingGroup mappingGrp = mappings.get(0);
        cacheDistr = mappingGrp.revertMappings(partCnt);
        for (int mpCacheId : mappingGrp.cacheIds()) {
            this.affinityCache.addCacheDistribution(mpCacheId, cacheDistr);
        }
        return cacheDistr;
    }

    public static Collection<Integer> calculatePartitions(JdbcThinPartitionResultDescriptor partResDesc, Object[] args) throws SQLException {
        PartitionResult derivedParts = partResDesc.partitionResult();
        if (derivedParts != null) {
            try {
                return derivedParts.tree().apply(partResDesc.partitionClientContext(), args);
            }
            catch (IgniteCheckedException e) {
                throw new SQLException("Failed to calculate derived partitions for query.", "50000");
            }
        }
        return null;
    }

    void sendQueryCancelRequest(JdbcQueryCancelRequest req, JdbcThinTcpIo cliIo) throws SQLException {
        if (!this.connected) {
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006");
        }
        assert (cliIo != null);
        try {
            cliIo.sendCancelRequest(req);
        }
        catch (Exception e) {
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestNotWaitResponse(JdbcOrderedBatchExecuteRequest req, JdbcThinTcpIo stickyIO) throws SQLException {
        this.ensureConnected();
        Object object = this.mux;
        synchronized (object) {
            if (this.ownThread != null) {
                throw new SQLException("Concurrent access to JDBC connection is not allowed [ownThread=" + this.ownThread.getName() + ", curThread=" + Thread.currentThread().getName(), "08006");
            }
            this.ownThread = Thread.currentThread();
        }
        try {
            stickyIO.sendBatchRequestNoWaitResponse(req);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            this.onDisconnect();
            if (e instanceof SocketTimeoutException) {
                throw new SQLException("Connection timed out.", "08006", e);
            }
            throw new SQLException("Failed to communicate with Ignite cluster.", "08006", e);
        }
        finally {
            Object object2 = this.mux;
            synchronized (object2) {
                this.ownThread = null;
            }
        }
    }

    public String url() {
        return this.connProps.getUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDisconnect() {
        if (!this.connected) {
            return;
        }
        if (this.partitionAwareness) {
            for (JdbcThinTcpIo clioIo : this.ios.values()) {
                clioIo.close();
            }
            this.ios.clear();
            this.iosArr = null;
        } else if (this.singleIo != null) {
            this.singleIo.close();
        }
        this.connected = false;
        if (this.streamState != null) {
            this.streamState.close0();
            this.streamState = null;
        }
        Object object = this.stmtsMux;
        synchronized (object) {
            for (JdbcThinStatement s : this.stmts) {
                s.closeOnDisconnect();
            }
            this.stmts.clear();
        }
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStatement(JdbcThinStatement stmt) {
        Object object = this.stmtsMux;
        synchronized (object) {
            this.stmts.remove(stmt);
        }
    }

    boolean isQueryCancellationSupported() {
        return this.cliIo(null).isQueryCancellationSupported();
    }

    private JdbcThinTcpIo cliIo(List<UUID> nodeIds) {
        if (!this.partitionAwareness) {
            return this.singleIo;
        }
        if (this.txIo != null) {
            return this.txIo;
        }
        if (nodeIds == null || nodeIds.isEmpty()) {
            return this.iosArr[RND.nextInt(this.iosArr.length)];
        }
        JdbcThinTcpIo io = null;
        if (nodeIds.size() == 1) {
            io = this.ios.get(nodeIds.iterator().next());
        } else {
            int initNodeId = RND.nextInt(nodeIds.size());
            int iterCnt = 0;
            while (io == null) {
                io = this.ios.get(nodeIds.get(initNodeId));
                int n = initNodeId = initNodeId == nodeIds.size() ? 0 : initNodeId + 1;
                if (++iterCnt != nodeIds.size()) continue;
            }
        }
        return io != null ? io : this.iosArr[RND.nextInt(this.iosArr.length)];
    }

    public int serverIndex() {
        return this.srvIdx;
    }

    private static int nextServerIndex(int len) {
        if (len == 1) {
            return 0;
        }
        long nextIdx = IDX_GEN.getAndIncrement();
        return (int)(nextIdx % (long)len);
    }

    private void connectInCommonMode(HostAndPortRange[] srvs) throws SQLException {
        ArrayList<Exception> exceptions = null;
        for (int i = 0; i < srvs.length; ++i) {
            this.srvIdx = JdbcThinConnection.nextServerIndex(srvs.length);
            HostAndPortRange srv = srvs[this.srvIdx];
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(srv.host())) {
                    for (int port = srv.portFrom(); port <= srv.portTo(); ++port) {
                        try {
                            JdbcThinTcpIo cliIo = new JdbcThinTcpIo(this.connProps, new InetSocketAddress(addr, port), 0);
                            cliIo.timeout(this.netTimeout);
                            this.singleIo = cliIo;
                            this.connected = true;
                            return;
                        }
                        catch (Exception exception) {
                            if (exceptions == null) {
                                exceptions = new ArrayList();
                            }
                            exceptions.add(exception);
                            continue;
                        }
                    }
                }
                continue;
            }
            catch (Exception exception) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(exception);
            }
        }
        this.handleConnectExceptions(exceptions);
    }

    private void handleConnectExceptions(List<Exception> exceptions) throws SQLException {
        if (!this.connected && exceptions != null) {
            this.close();
            if (exceptions.size() == 1) {
                Exception ex = exceptions.get(0);
                if (ex instanceof SQLException) {
                    throw (SQLException)ex;
                }
                if (ex instanceof IOException) {
                    throw new SQLException("Failed to connect to Ignite cluster [url=" + this.connProps.getUrl() + ']', "08001", ex);
                }
            }
            SQLException e = new SQLException("Failed to connect to server [url=" + this.connProps.getUrl() + ']', "08001");
            for (Exception ex : exceptions) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    private void connectInAffinityAwarenessMode(HostAndPortRange[] srvs) throws SQLException {
        ArrayList<Exception> exceptions = null;
        IgniteProductVersion prevIgniteEnpointVer = null;
        for (int i = 0; i < srvs.length; ++i) {
            HostAndPortRange srv = srvs[i];
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName(srv.host())) {
                    for (int port = srv.portFrom(); port <= srv.portTo(); ++port) {
                        try {
                            JdbcThinTcpIo cliIo = new JdbcThinTcpIo(this.connProps, new InetSocketAddress(addr, port), 0);
                            if (!cliIo.isPartitionAwarenessSupported()) {
                                throw new SQLException("Failed to connect to Ignite node [url=" + this.connProps.getUrl() + "]. address = [" + addr + ':' + port + "].Node doesn't support partition awareness mode.", "50000");
                            }
                            if (prevIgniteEnpointVer != null && !prevIgniteEnpointVer.equals(cliIo.igniteVersion())) {
                                throw new SQLException("Failed to connect to Ignite node [url=" + this.connProps.getUrl() + "]. address = [" + addr + ':' + port + "].Different versions of nodes are not supported in affinity awareness mode.", "50000");
                            }
                            cliIo.timeout(this.netTimeout);
                            JdbcThinTcpIo ioToSameNode = this.ios.get(cliIo.nodeId());
                            if (ioToSameNode != null) {
                                ioToSameNode.close();
                            }
                            this.ios.put(cliIo.nodeId(), cliIo);
                            this.connected = true;
                            prevIgniteEnpointVer = cliIo.igniteVersion();
                            continue;
                        }
                        catch (Exception exception) {
                            if (exceptions == null) {
                                exceptions = new ArrayList();
                            }
                            exceptions.add(exception);
                        }
                    }
                }
                continue;
            }
            catch (Exception exception) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Exception>();
                }
                exceptions.add(exception);
            }
        }
        this.handleConnectExceptions(exceptions);
        this.iosArr = this.ios.values().toArray(new JdbcThinTcpIo[0]);
    }

    private void updateAffinityCache(JdbcQueryExecuteRequest qryReq, JdbcResponse res) {
        if (this.partitionAwareness) {
            PartitionResult partRes;
            AffinityTopologyVersion resAffVer = res.affinityVersion();
            if (resAffVer != null && (this.affinityCache == null || this.affinityCache.version().compareTo(resAffVer) < 0)) {
                this.affinityCache = new AffinityCache(resAffVer);
            }
            if (res.response() instanceof JdbcQueryExecuteResult && qryReq.partitionResponseRequest() && ((partRes = ((JdbcQueryExecuteResult)res.response()).partitionResult()) == null || this.affinityCache.version().equals(partRes.topologyVersion()))) {
                int cacheId = partRes != null && partRes.tree() != null ? GridCacheUtils.cacheId(partRes.cacheName()) : -1;
                PartitionClientContext partClientCtx = partRes != null ? new PartitionClientContext(partRes.partitionsCount()) : null;
                QualifiedSQLQuery qry = new QualifiedSQLQuery(qryReq.schemaName(), qryReq.sqlQuery());
                JdbcThinPartitionResultDescriptor partResDescr = new JdbcThinPartitionResultDescriptor(partRes, cacheId, partClientCtx);
                this.affinityCache.addSqlQuery(qry, partResDescr);
            }
        }
    }

    private class RequestTimeoutTimerTask
    extends TimerTask {
        private final long reqId;
        private final JdbcThinTcpIo stickyIO;
        private int remainingQryTimeout;
        private AtomicBoolean expired;

        RequestTimeoutTimerTask(long reqId, JdbcThinTcpIo stickyIO, int initReqTimeout) {
            this.reqId = reqId;
            this.stickyIO = stickyIO;
            this.remainingQryTimeout = initReqTimeout;
            this.expired = new AtomicBoolean(false);
        }

        @Override
        public void run() {
            try {
                if (this.remainingQryTimeout <= 0) {
                    this.expired.set(true);
                    JdbcThinConnection.this.sendQueryCancelRequest(new JdbcQueryCancelRequest(this.reqId), this.stickyIO);
                    this.cancel();
                }
                this.remainingQryTimeout -= 1000;
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Request timeout processing failure: unable to cancel request [reqId=" + this.reqId + ']', e);
                this.cancel();
            }
        }

        static /* synthetic */ AtomicBoolean access$000(RequestTimeoutTimerTask x0) {
            return x0.expired;
        }
    }

    private class StreamState {
        private static final int MAX_REQUESTS_BEFORE_RESPONSE = 10;
        private int streamBatchSize;
        private List<JdbcQuery> streamBatch;
        private String lastStreamQry;
        private long order;
        private Thread asyncRespReaderThread;
        private volatile Exception err;
        private long lastRespOrder = -1L;
        private final GridFutureAdapter<Void> lastRespFut = new GridFutureAdapter();
        private Semaphore respSem = new Semaphore(10);
        private final JdbcThinTcpIo streamingStickyIo;

        StreamState(SqlSetStreamingCommand cmd, JdbcThinTcpIo stickyIo) {
            this.streamBatchSize = cmd.batchSize();
            this.asyncRespReaderThread = new Thread(this::readResponses);
            this.streamingStickyIo = stickyIo;
        }

        void start() {
            this.asyncRespReaderThread.start();
        }

        void addBatch(String sql, List<Object> args) throws SQLException {
            this.checkError();
            boolean newQry = args == null || !F.eq(this.lastStreamQry, sql);
            JdbcQuery q = new JdbcQuery(newQry ? sql : null, args != null ? args.toArray() : null);
            if (this.streamBatch == null) {
                this.streamBatch = new ArrayList<JdbcQuery>(this.streamBatchSize);
            }
            this.streamBatch.add(q);
            String string = this.lastStreamQry = args != null ? sql : null;
            if (this.streamBatch.size() == this.streamBatchSize) {
                this.executeBatch(false);
            }
        }

        private void executeBatch(boolean lastBatch) throws SQLException {
            block6: {
                this.checkError();
                if (lastBatch) {
                    this.lastRespOrder = this.order;
                }
                try {
                    this.respSem.acquire();
                    JdbcThinConnection.this.sendRequestNotWaitResponse(new JdbcOrderedBatchExecuteRequest(JdbcThinConnection.this.schema, this.streamBatch, JdbcThinConnection.this.autoCommit, lastBatch, this.order), this.streamingStickyIo);
                    this.streamBatch = null;
                    this.lastStreamQry = null;
                    if (lastBatch) {
                        try {
                            this.lastRespFut.get();
                        }
                        catch (IgniteCheckedException igniteCheckedException) {
                            // empty catch block
                        }
                        this.checkError();
                        break block6;
                    }
                    ++this.order;
                }
                catch (InterruptedException e) {
                    throw new SQLException("Streaming operation was interrupted", "50000", e);
                }
            }
        }

        void checkError() throws SQLException {
            if (this.err != null) {
                Exception err0 = this.err;
                this.err = null;
                if (err0 instanceof SQLException) {
                    throw (SQLException)err0;
                }
                JdbcThinConnection.this.onDisconnect();
                if (err0 instanceof SocketTimeoutException) {
                    throw new SQLException("Connection timed out.", "08006", err0);
                }
                throw new SQLException("Failed to communicate with Ignite cluster on JDBC streaming.", "08006", err0);
            }
        }

        void close() throws SQLException {
            this.close0();
            this.checkError();
        }

        void close0() {
            if (JdbcThinConnection.this.connected) {
                try {
                    this.executeBatch(true);
                }
                catch (SQLException e) {
                    this.err = e;
                    LOG.log(Level.WARNING, "Exception during batch send on streamed connection close", e);
                }
            }
            if (this.asyncRespReaderThread != null) {
                this.asyncRespReaderThread.interrupt();
            }
        }

        void readResponses() {
            try {
                block6: {
                    JdbcResponse resp;
                    while (true) {
                        if ((resp = this.streamingStickyIo.readResponse()).response() instanceof JdbcOrderedBatchExecuteResult) {
                            JdbcOrderedBatchExecuteResult res = (JdbcOrderedBatchExecuteResult)resp.response();
                            this.respSem.release();
                            if (res.errorCode() != 0) {
                                this.err = new BatchUpdateException(res.errorMessage(), IgniteQueryErrorCode.codeToSqlState(res.errorCode()), res.errorCode(), res.updateCounts());
                            }
                            if (res.order() != this.lastRespOrder) continue;
                            break block6;
                        }
                        if (resp.status() != 0) {
                            this.err = new SQLException(resp.error(), IgniteQueryErrorCode.codeToSqlState(resp.status()));
                            continue;
                        }
                        if (!$assertionsDisabled) break;
                    }
                    throw new AssertionError((Object)("Invalid response: " + resp));
                }
                this.lastRespFut.onDone();
            }
            catch (Exception e) {
                this.err = e;
            }
        }
    }
}

