/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.encryption;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.encryption.GenerateEncryptionKeyRequest;
import org.apache.ignite.internal.managers.encryption.GenerateEncryptionKeyResponse;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteFutureCancelledException;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.jetbrains.annotations.Nullable;

public class GridEncryptionManager
extends GridManagerAdapter<EncryptionSpi>
implements MetastorageLifecycleListener,
IgniteChangeGlobalStateSupport {
    private static final IgniteProductVersion CACHE_ENCRYPTION_SINCE = IgniteProductVersion.fromString("2.7.0");
    private final Object metaStorageMux = new Object();
    private final Object genEcnKeyMux = new Object();
    private volatile boolean disconnected;
    private volatile boolean stopped;
    private volatile boolean writeToMetaStoreEnabled;
    public static final String ENCRYPTION_KEY_PREFIX = "grp-encryption-key-";
    private final ConcurrentHashMap<Integer, Serializable> grpEncKeys = new ConcurrentHashMap();
    private ConcurrentMap<IgniteUuid, GenerateEncryptionKeyFuture> genEncKeyFuts = new ConcurrentHashMap<IgniteUuid, GenerateEncryptionKeyFuture>();
    private volatile ReadWriteMetastorage metaStorage;
    private GridMessageListener ioLsnr;
    private DiscoveryEventListener discoLsnr;

    public GridEncryptionManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new EncryptionSpi[]{ctx.config().getEncryptionSpi()});
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.startSpi();
        if (((EncryptionSpi)this.getSpi()).masterKeyDigest() != null) {
            this.ctx.addNodeAttribute("org.apache.ignite.master.key.digest", ((EncryptionSpi)this.getSpi()).masterKeyDigest());
        }
        this.discoLsnr = (evt, discoCache) -> {
            UUID leftNodeId = evt.eventNode().id();
            Object object = this.genEcnKeyMux;
            synchronized (object) {
                Iterator futsIter = this.genEncKeyFuts.entrySet().iterator();
                while (futsIter.hasNext()) {
                    GenerateEncryptionKeyFuture fut = (GenerateEncryptionKeyFuture)futsIter.next().getValue();
                    if (!F.eq(leftNodeId, fut.nodeId())) {
                        return;
                    }
                    try {
                        futsIter.remove();
                        this.sendGenerateEncryptionKeyRequest(fut);
                        this.genEncKeyFuts.put(fut.id(), fut);
                    }
                    catch (IgniteCheckedException e) {
                        fut.onDone(null, (Throwable)e);
                    }
                }
            }
        };
        this.ctx.event().addDiscoveryEventListener(this.discoLsnr, 11, 12);
        this.ioLsnr = (nodeId, msg, plc) -> {
            Object object = this.genEcnKeyMux;
            synchronized (object) {
                if (msg instanceof GenerateEncryptionKeyRequest) {
                    GenerateEncryptionKeyRequest req = (GenerateEncryptionKeyRequest)msg;
                    assert (req.keyCount() != 0);
                    ArrayList<byte[]> encKeys = new ArrayList<byte[]>(req.keyCount());
                    for (int i = 0; i < req.keyCount(); ++i) {
                        encKeys.add(((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
                    }
                    try {
                        this.ctx.io().sendToGridTopic(nodeId, GridTopic.TOPIC_GEN_ENC_KEY, (Message)new GenerateEncryptionKeyResponse(req.id(), encKeys), (byte)2);
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Unable to send generate key response[nodeId=" + nodeId + "]");
                    }
                } else {
                    GenerateEncryptionKeyResponse resp = (GenerateEncryptionKeyResponse)msg;
                    GenerateEncryptionKeyFuture fut = (GenerateEncryptionKeyFuture)this.genEncKeyFuts.get(resp.requestId());
                    if (fut != null) {
                        fut.onDone(resp.encryptionKeys(), (Throwable)null);
                    } else {
                        U.warn(this.log, "Response received for a unknown request.[reqId=" + resp.requestId() + "]");
                    }
                }
            }
        };
        this.ctx.io().addMessageListener(GridTopic.TOPIC_GEN_ENC_KEY, this.ioLsnr);
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        this.stopSpi();
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        Object object = this.genEcnKeyMux;
        synchronized (object) {
            this.stopped = true;
            if (this.ioLsnr != null) {
                this.ctx.io().removeMessageListener(GridTopic.TOPIC_GEN_ENC_KEY, this.ioLsnr);
            }
            if (this.discoLsnr != null) {
                this.ctx.event().removeDiscoveryEventListener(this.discoLsnr, 11, 12);
            }
            this.cancelFutures("Kernal stopped.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) {
        Object object = this.genEcnKeyMux;
        synchronized (object) {
            assert (!this.disconnected);
            this.disconnected = true;
            this.cancelFutures("Client node was disconnected from topology (operation result is unknown).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) {
        Object object = this.genEcnKeyMux;
        synchronized (object) {
            assert (this.disconnected);
            this.disconnected = false;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLocalJoin() {
        if (this.notCoordinator()) {
            return;
        }
        Object object = this.metaStorageMux;
        synchronized (object) {
            HashMap<Integer, byte[]> knownEncKeys = this.knownEncryptionKeys();
            HashMap<Integer, byte[]> newEncKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
            if (newEncKeys == null) {
                return;
            }
            for (Map.Entry<Integer, byte[]> entry : newEncKeys.entrySet()) {
                this.groupKey(entry.getKey(), entry.getValue());
                U.quietAndInfo(this.log, "Added encryption key on local join [grpId=" + entry.getKey() + "]");
            }
        }
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        IgniteNodeValidationResult res = super.validateNode(node, discoData);
        if (res != null) {
            return res;
        }
        if (node.isClient()) {
            return null;
        }
        res = this.validateNode(node);
        if (res != null) {
            return res;
        }
        if (!discoData.hasJoiningNodeData()) {
            U.quietAndInfo(this.log, "Joining node doesn't have encryption data [node=" + node.id() + "]");
            return null;
        }
        NodeEncryptionKeys nodeEncKeys = (NodeEncryptionKeys)discoData.joiningNodeData();
        if (nodeEncKeys == null || F.isEmpty(nodeEncKeys.knownKeys)) {
            U.quietAndInfo(this.log, "Joining node doesn't have stored group keys [node=" + node.id() + "]");
            return null;
        }
        for (Map.Entry<Integer, byte[]> entry : nodeEncKeys.knownKeys.entrySet()) {
            Serializable rmtKey;
            Serializable locEncKey = this.grpEncKeys.get(entry.getKey());
            if (locEncKey == null || F.eq(locEncKey, rmtKey = ((EncryptionSpi)this.getSpi()).decryptKey(entry.getValue()))) continue;
            return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Cache key differs! Node join is rejected. [node=" + node.id() + ", grp=" + entry.getKey() + "]", "Cache key differs! Node join is rejected.");
        }
        return null;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        byte[] rmtMkDig;
        IgniteNodeValidationResult res = super.validateNode(node);
        if (res != null) {
            return res;
        }
        if (node.isClient()) {
            return null;
        }
        byte[] lclMkDig = ((EncryptionSpi)this.getSpi()).masterKeyDigest();
        if (Arrays.equals(lclMkDig, rmtMkDig = (byte[])node.attribute("org.apache.ignite.master.key.digest"))) {
            return null;
        }
        return new IgniteNodeValidationResult(this.ctx.localNodeId(), "Master key digest differs! Node join is rejected. [node=" + node.id() + "]", "Master key digest differs! Node join is rejected.");
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
        HashMap<Integer, byte[]> knownEncKeys = this.knownEncryptionKeys();
        HashMap<Integer, byte[]> newKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
        if (knownEncKeys == null && newKeys == null || dataBag.isJoiningNodeClient()) {
            return;
        }
        if (this.log.isInfoEnabled()) {
            String newGrps;
            String knownGrps;
            String string = knownGrps = F.isEmpty(knownEncKeys) ? null : F.concat(knownEncKeys.keySet(), ",");
            if (knownGrps != null) {
                U.quietAndInfo(this.log, "Sending stored group keys to coordinator [grps=" + knownGrps + "]");
            }
            String string2 = newGrps = F.isEmpty(newKeys) ? null : F.concat(newKeys.keySet(), ",");
            if (newGrps != null) {
                U.quietAndInfo(this.log, "Sending new group keys to coordinator [grps=" + newGrps + "]");
            }
        }
        dataBag.addJoiningNodeData(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal(), new NodeEncryptionKeys(knownEncKeys, newKeys));
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
        NodeEncryptionKeys nodeEncryptionKeys = (NodeEncryptionKeys)data.joiningNodeData();
        if (nodeEncryptionKeys == null || nodeEncryptionKeys.newKeys == null || this.ctx.clientNode()) {
            return;
        }
        for (Map.Entry<Integer, byte[]> entry : nodeEncryptionKeys.newKeys.entrySet()) {
            if (this.groupKey(entry.getKey()) == null) {
                U.quietAndInfo(this.log, "Store group key received from joining node [node=" + data.joiningNodeId() + ", grp=" + entry.getKey() + "]");
                this.groupKey(entry.getKey(), entry.getValue());
                continue;
            }
            U.quietAndInfo(this.log, "Skip group key received from joining node. Already exists. [node=" + data.joiningNodeId() + ", grp=" + entry.getKey() + "]");
        }
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        if (dataBag.isJoiningNodeClient() || dataBag.commonDataCollectedFor(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal())) {
            return;
        }
        HashMap<Integer, byte[]> knownEncKeys = this.knownEncryptionKeys();
        HashMap<Integer, byte[]> newKeys = this.newEncryptionKeys(knownEncKeys == null ? Collections.EMPTY_SET : knownEncKeys.keySet());
        if (knownEncKeys == null) {
            knownEncKeys = newKeys;
        } else if (newKeys != null) {
            for (Map.Entry<Integer, byte[]> entry : newKeys.entrySet()) {
                byte[] old = knownEncKeys.putIfAbsent(entry.getKey(), entry.getValue());
                assert (old == null);
            }
        }
        dataBag.addGridCommonData(GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR.ordinal(), knownEncKeys);
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        Map encKeysFromCluster = (Map)((Object)data.commonData());
        if (F.isEmpty(encKeysFromCluster)) {
            return;
        }
        for (Map.Entry entry : encKeysFromCluster.entrySet()) {
            if (this.groupKey((Integer)entry.getKey()) == null) {
                U.quietAndInfo(this.log, "Store group key received from coordinator [grp=" + entry.getKey() + "]");
                this.groupKey((Integer)entry.getKey(), (byte[])entry.getValue());
                continue;
            }
            U.quietAndInfo(this.log, "Skip group key received from coordinator. Already exists. [grp=" + entry.getKey() + "]");
        }
    }

    @Nullable
    public Serializable groupKey(int grpId) {
        if (this.grpEncKeys.isEmpty()) {
            return null;
        }
        return this.grpEncKeys.get(grpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void groupKey(int grpId, byte[] encGrpKey) {
        assert (!this.grpEncKeys.containsKey(grpId));
        Serializable encKey = ((EncryptionSpi)this.getSpi()).decryptKey(encGrpKey);
        Object object = this.metaStorageMux;
        synchronized (object) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Key added. [grp=" + grpId + "]");
            }
            this.grpEncKeys.put(grpId, encKey);
            this.writeToMetaStore(grpId, encGrpKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGroupKey(int grpId) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.ctx.cache().context().database().checkpointReadLock();
            try {
                this.grpEncKeys.remove(grpId);
                this.metaStorage.remove(ENCRYPTION_KEY_PREFIX + grpId);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Key removed. [grp=" + grpId + "]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to clear meta storage", e);
            }
            finally {
                this.ctx.cache().context().database().checkpointReadUnlock();
            }
        }
    }

    public void beforeCacheGroupStart(int grpId, @Nullable byte[] encKey) {
        if (encKey == null || this.ctx.clientNode()) {
            return;
        }
        this.groupKey(grpId, encKey);
    }

    public void onCacheGroupDestroyed(int grpId) {
        if (this.groupKey(grpId) == null) {
            return;
        }
        this.removeGroupKey(grpId);
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metastorage) {
        try {
            metastorage.iterate(ENCRYPTION_KEY_PREFIX, (key, val) -> {
                Integer grpId = Integer.valueOf(key.replace(ENCRYPTION_KEY_PREFIX, ""));
                byte[] encGrpKey = (byte[])val;
                this.grpEncKeys.putIfAbsent(grpId, ((EncryptionSpi)this.getSpi()).decryptKey(encGrpKey));
            }, true);
            if (!this.grpEncKeys.isEmpty()) {
                U.quietAndInfo(this.log, "Encryption keys loaded from metastore. [grps=" + F.concat(this.grpEncKeys.keySet(), ",") + "]");
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to read encryption keys state.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metaStorage) throws IgniteCheckedException {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.metaStorage = metaStorage;
            this.writeToMetaStoreEnabled = true;
            this.writeAllToMetaStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        Object object = this.metaStorageMux;
        synchronized (object) {
            boolean bl = this.writeToMetaStoreEnabled = this.metaStorage != null;
            if (this.writeToMetaStoreEnabled) {
                this.writeAllToMetaStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeActivate(GridKernalContext kctx) {
        Object object = this.metaStorageMux;
        synchronized (object) {
            this.writeToMetaStoreEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteInternalFuture<Collection<byte[]>> generateKeys(int keyCnt) {
        if (keyCnt == 0 || !this.ctx.clientNode()) {
            return new GridFinishedFuture<Collection<byte[]>>(this.createKeys(keyCnt));
        }
        Object object = this.genEcnKeyMux;
        synchronized (object) {
            if (this.disconnected || this.stopped) {
                return new GridFinishedFuture<Collection<byte[]>>(new IgniteFutureCancelledException("Node " + (this.stopped ? "stopped" : "disconnected")));
            }
            try {
                GenerateEncryptionKeyFuture genEncKeyFut = new GenerateEncryptionKeyFuture(keyCnt);
                this.sendGenerateEncryptionKeyRequest(genEncKeyFut);
                this.genEncKeyFuts.put(genEncKeyFut.id(), genEncKeyFut);
                return genEncKeyFut;
            }
            catch (IgniteCheckedException e) {
                return new GridFinishedFuture<Collection<byte[]>>(e);
            }
        }
    }

    private void sendGenerateEncryptionKeyRequest(GenerateEncryptionKeyFuture fut) throws IgniteCheckedException {
        ClusterNode rndNode = U.randomServerNode(this.ctx);
        if (rndNode == null) {
            throw new IgniteCheckedException("There is no node to send GenerateEncryptionKeyRequest to");
        }
        GenerateEncryptionKeyRequest req = new GenerateEncryptionKeyRequest(fut.keyCount());
        fut.id(req.id());
        fut.nodeId(rndNode.id());
        this.ctx.io().sendToGridTopic(rndNode.id(), GridTopic.TOPIC_GEN_ENC_KEY, (Message)req, (byte)2);
    }

    private void writeAllToMetaStore() throws IgniteCheckedException {
        for (Map.Entry<Integer, Serializable> entry : this.grpEncKeys.entrySet()) {
            if (this.metaStorage.read(ENCRYPTION_KEY_PREFIX + entry.getKey()) != null) continue;
            this.writeToMetaStore(entry.getKey(), ((EncryptionSpi)this.getSpi()).encryptKey(entry.getValue()));
        }
    }

    public void checkEncryptedCacheSupported() throws IgniteCheckedException {
        Collection<ClusterNode> nodes = this.ctx.grid().cluster().nodes();
        for (ClusterNode node : nodes) {
            if (CACHE_ENCRYPTION_SINCE.compareTo(node.version()) <= 0) continue;
            throw new IgniteCheckedException("All nodes in cluster should be 2.7.0 or greater to create encrypted cache! [nodeId=" + node.id() + "]");
        }
    }

    @Override
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.ENCRYPTION_MGR;
    }

    private void writeToMetaStore(int grpId, byte[] encGrpKey) {
        if (this.metaStorage == null || !this.writeToMetaStoreEnabled) {
            return;
        }
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            this.metaStorage.write(ENCRYPTION_KEY_PREFIX + grpId, (Serializable)encGrpKey);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to write cache group encryption key [grpId=" + grpId + ']', e);
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    @Nullable
    private HashMap<Integer, byte[]> newEncryptionKeys(Set<Integer> knownKeys) {
        Map<Integer, CacheGroupDescriptor> grpDescs = this.ctx.cache().cacheGroupDescriptors();
        HashMap<Integer, byte[]> newKeys = null;
        for (CacheGroupDescriptor grpDesc : grpDescs.values()) {
            if (knownKeys.contains(grpDesc.groupId()) || !grpDesc.config().isEncryptionEnabled()) continue;
            if (newKeys == null) {
                newKeys = new HashMap<Integer, byte[]>();
            }
            newKeys.put(grpDesc.groupId(), ((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
        }
        return newKeys;
    }

    @Nullable
    private HashMap<Integer, byte[]> knownEncryptionKeys() {
        if (F.isEmpty(this.grpEncKeys)) {
            return null;
        }
        HashMap<Integer, byte[]> knownKeys = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, Serializable> entry : this.grpEncKeys.entrySet()) {
            knownKeys.put(entry.getKey(), ((EncryptionSpi)this.getSpi()).encryptKey(entry.getValue()));
        }
        return knownKeys;
    }

    private Collection<byte[]> createKeys(int keyCnt) {
        if (keyCnt == 0) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> encKeys = new ArrayList<byte[]>(keyCnt);
        for (int i = 0; i < keyCnt; ++i) {
            encKeys.add(((EncryptionSpi)this.getSpi()).encryptKey(((EncryptionSpi)this.getSpi()).create()));
        }
        return encKeys;
    }

    private void cancelFutures(String msg) {
        for (GenerateEncryptionKeyFuture fut : this.genEncKeyFuts.values()) {
            fut.onDone(new IgniteFutureCancelledException(msg));
        }
    }

    private boolean notCoordinator() {
        DiscoverySpi spi = this.ctx.discovery().getInjectedDiscoverySpi();
        if (spi instanceof TcpDiscoverySpi) {
            return !((TcpDiscoverySpi)spi).isLocalNodeCoordinator();
        }
        ClusterNode crd = null;
        for (ClusterNode node : this.ctx.discovery().aliveServerNodes()) {
            if (crd != null && crd.order() <= node.order()) continue;
            crd = node;
        }
        return crd == null || !F.eq(this.ctx.localNodeId(), crd.id());
    }

    private class GenerateEncryptionKeyFuture
    extends GridFutureAdapter<Collection<byte[]>> {
        private IgniteUuid id;
        private int keyCnt;
        private UUID nodeId;

        private GenerateEncryptionKeyFuture(int keyCnt) {
            this.keyCnt = keyCnt;
        }

        @Override
        public boolean onDone(@Nullable Collection<byte[]> res, @Nullable Throwable err) {
            GridEncryptionManager.this.genEncKeyFuts.remove(this.id, this);
            return super.onDone(res, err);
        }

        public IgniteUuid id() {
            return this.id;
        }

        public void id(IgniteUuid id) {
            this.id = id;
        }

        public UUID nodeId() {
            return this.nodeId;
        }

        public void nodeId(UUID nodeId) {
            this.nodeId = nodeId;
        }

        public int keyCount() {
            return this.keyCnt;
        }

        @Override
        public String toString() {
            return S.toString(GenerateEncryptionKeyFuture.class, this);
        }
    }

    public static class NodeEncryptionKeys
    implements Serializable {
        private static final long serialVersionUID = 0L;
        Map<Integer, byte[]> knownKeys;
        Map<Integer, byte[]> newKeys;

        NodeEncryptionKeys(Map<Integer, byte[]> knownKeys, Map<Integer, byte[]> newKeys) {
            this.knownKeys = knownKeys;
            this.newKeys = newKeys;
        }
    }
}

