/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite.internal.managers.systemview.AbstractSystemView;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.jetbrains.annotations.NotNull;

public class SystemViewInnerCollectionsAdapter<C, R, D>
extends AbstractSystemView<R> {
    private final Collection<C> containers;
    private final Function<C, Collection<D>> dataExtractor;
    private final BiFunction<C, D, R> rowFunc;

    public SystemViewInnerCollectionsAdapter(String name, String desc, Class<R> rowCls, SystemViewRowAttributeWalker<R> walker, Collection<C> containers, Function<C, Collection<D>> dataExtractor, BiFunction<C, D, R> rowFunc) {
        super(name, desc, rowCls, walker);
        this.containers = containers;
        this.dataExtractor = dataExtractor;
        this.rowFunc = rowFunc;
    }

    @Override
    public int size() {
        int sz = 0;
        for (C c : this.containers) {
            sz += this.dataExtractor.apply(c).size();
        }
        return sz;
    }

    @Override
    @NotNull
    public Iterator<R> iterator() {
        return F.concat(F.iterator(this.containers, c -> F.iterator(this.dataExtractor.apply(c).iterator(), d -> this.rowFunc.apply(c, d), true, new IgnitePredicate[0]), true, new IgnitePredicate[0]));
    }
}

