/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.authentication;

import org.apache.ignite.internal.processors.authentication.IgniteAccessControlException;
import org.apache.ignite.internal.processors.authentication.User;
import org.apache.ignite.internal.processors.authentication.UserManagementOperation;

public class AuthorizationContext {
    private final User user;
    private static ThreadLocal<AuthorizationContext> actx = new ThreadLocal();

    public AuthorizationContext(User user) {
        assert (user != null);
        this.user = user;
    }

    public String userName() {
        return this.user.name();
    }

    public void checkUserOperation(UserManagementOperation op) throws IgniteAccessControlException {
        assert (op != null);
        if (this.user == null) {
            throw new IgniteAccessControlException("Operation not allowed: authorized context is empty.");
        }
        if (!("ignite".equals(this.user.name()) || UserManagementOperation.OperationType.UPDATE == op.type() && this.user.name().equals(op.user().name()))) {
            throw new IgniteAccessControlException("User management operations are not allowed for user. [curUser=" + this.user.name() + ']');
        }
        if (op.type() == UserManagementOperation.OperationType.REMOVE && "ignite".equals(op.user().name())) {
            throw new IgniteAccessControlException("Default user cannot be removed.");
        }
    }

    public static void context(AuthorizationContext actx) {
        AuthorizationContext.actx.set(actx);
    }

    public static void clear() {
        actx.set(null);
    }

    public static AuthorizationContext context() {
        return actx.get();
    }
}

