/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class ExchangeContext {
    public static final String IGNITE_EXCHANGE_COMPATIBILITY_VER_1 = "IGNITE_EXCHANGE_COMPATIBILITY_VER_1";
    private final IgniteLogger log;
    private Set<Integer> requestGrpsAffOnJoin;
    private boolean fetchAffOnJoin;
    private boolean exchangeFreeSwitch;
    private final boolean merge;
    private final ExchangeDiscoveryEvents evts;
    private final boolean compatibilityNode = IgniteSystemProperties.getBoolean("IGNITE_EXCHANGE_COMPATIBILITY_VER_1", false);

    public ExchangeContext(GridCacheSharedContext<?, ?> cctx, boolean crd, GridDhtPartitionsExchangeFuture fut) {
        this.log = cctx.logger(this.getClass());
        int protocolVer = GridCachePartitionExchangeManager.exchangeProtocolVersion(fut.firstEventCache().minimumNodeVersion());
        boolean allNodesSupportsPmeFreeSwitch = IgniteFeatures.allNodesSupports(fut.firstEventCache().allNodes(), IgniteFeatures.PME_FREE_SWITCH);
        if (!allNodesSupportsPmeFreeSwitch) {
            this.log.warning("Current topology does not support the PME-free switch. Please check all nodes support this feature and it was not explicitly disabled by IGNITE_PME_FREE_SWITCH_DISABLED JVM option.");
        }
        if (!this.compatibilityNode && fut.wasRebalanced() && fut.isBaselineNodeFailed() && allNodesSupportsPmeFreeSwitch) {
            this.exchangeFreeSwitch = true;
            this.merge = false;
        } else if (this.compatibilityNode || crd && fut.localJoinExchange()) {
            this.fetchAffOnJoin = true;
            this.merge = false;
        } else {
            boolean startCaches = fut.exchangeId().isJoined() && fut.sharedContext().cache().hasCachesReceivedFromJoin(fut.exchangeId().eventNode());
            this.fetchAffOnJoin = protocolVer == 1;
            this.merge = !startCaches && protocolVer > 1 && fut.firstEvent().type() != 18;
        }
        this.evts = new ExchangeDiscoveryEvents(fut);
    }

    boolean supportsMergeExchanges(ClusterNode node) {
        return !this.compatibilityNode && GridCachePartitionExchangeManager.exchangeProtocolVersion(node.version()) > 1;
    }

    public ExchangeDiscoveryEvents events() {
        return this.evts;
    }

    public boolean fetchAffinityOnJoin() {
        return this.fetchAffOnJoin;
    }

    public boolean exchangeFreeSwitch() {
        return this.exchangeFreeSwitch;
    }

    synchronized void addGroupAffinityRequestOnJoin(Integer grpId) {
        if (this.requestGrpsAffOnJoin == null) {
            this.requestGrpsAffOnJoin = new HashSet<Integer>();
        }
        this.requestGrpsAffOnJoin.add(grpId);
    }

    @Nullable
    public synchronized Set<Integer> groupsAffinityRequestOnJoin() {
        return this.requestGrpsAffOnJoin;
    }

    public boolean mergeExchanges() {
        return this.merge;
    }

    public String toString() {
        return S.toString(ExchangeContext.class, this);
    }
}

