/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryPredicate;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheDeployable;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridInvokeValue;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.EnlistOperation;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridNearTxEnlistRequest
extends GridCacheIdMessage
implements GridCacheDeployable {
    private static final long serialVersionUID = 0L;
    private long threadId;
    private IgniteUuid futId;
    private boolean clientFirst;
    private int miniId;
    private UUID subjId;
    private AffinityTopologyVersion topVer;
    private GridCacheVersion lockVer;
    private MvccSnapshot mvccSnapshot;
    private long timeout;
    private long txTimeout;
    private int taskNameHash;
    @GridDirectTransient
    private Collection<Object> rows;
    @GridToStringExclude
    private KeyCacheObject[] keys;
    @GridToStringExclude
    private Message[] values;
    private EnlistOperation op;
    private boolean keepBinary;
    @GridToStringExclude
    private CacheEntryPredicate filter;
    private boolean needRes;

    public GridNearTxEnlistRequest() {
    }

    GridNearTxEnlistRequest(int cacheId, long threadId, IgniteUuid futId, int miniId, UUID subjId, AffinityTopologyVersion topVer, GridCacheVersion lockVer, MvccSnapshot mvccSnapshot, boolean clientFirst, long timeout, long txTimeout, int taskNameHash, Collection<Object> rows, EnlistOperation op, boolean needRes, boolean keepBinary, @Nullable CacheEntryPredicate filter) {
        this.txTimeout = txTimeout;
        this.keepBinary = keepBinary;
        this.filter = filter;
        this.cacheId = cacheId;
        this.threadId = threadId;
        this.futId = futId;
        this.miniId = miniId;
        this.subjId = subjId;
        this.topVer = topVer;
        this.lockVer = lockVer;
        this.mvccSnapshot = mvccSnapshot;
        this.clientFirst = clientFirst;
        this.timeout = timeout;
        this.taskNameHash = taskNameHash;
        this.rows = rows;
        this.op = op;
        this.needRes = needRes;
    }

    public long threadId() {
        return this.threadId;
    }

    public IgniteUuid futureId() {
        return this.futId;
    }

    public int miniId() {
        return this.miniId;
    }

    public UUID subjectId() {
        return this.subjId;
    }

    @Override
    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public GridCacheVersion version() {
        return this.lockVer;
    }

    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public long timeout() {
        return this.timeout;
    }

    public long txTimeout() {
        return this.txTimeout;
    }

    public int taskNameHash() {
        return this.taskNameHash;
    }

    public boolean firstClientRequest() {
        return this.clientFirst;
    }

    public Collection<Object> rows() {
        return this.rows;
    }

    public EnlistOperation operation() {
        return this.op;
    }

    public boolean needRes() {
        return this.needRes;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    public CacheEntryPredicate filter() {
        return this.filter;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        CacheObjectContext objCtx = cctx.cacheObjectContext();
        if (this.rows != null && this.keys == null) {
            if (!this.addDepInfo && ctx.deploymentEnabled()) {
                this.addDepInfo = true;
            }
            this.keys = new KeyCacheObject[this.rows.size()];
            int i = 0;
            boolean keysOnly = this.op.isDeleteOrLock();
            this.values = keysOnly ? null : new Message[this.keys.length];
            for (Object row : this.rows) {
                Object key;
                Object val = null;
                if (keysOnly) {
                    key = row;
                } else {
                    key = ((IgniteBiTuple)row).getKey();
                    val = ((IgniteBiTuple)row).getValue();
                }
                assert (key != null && (keysOnly || val != null)) : "key=" + key + ", val=" + val;
                KeyCacheObject key0 = cctx.toCacheKeyObject(key);
                assert (key0 != null);
                key0.prepareMarshal(objCtx);
                this.keys[i] = key0;
                if (!keysOnly) {
                    Message val0;
                    if (this.op.isInvoke()) {
                        val0 = val;
                        this.prepareInvokeValue(cctx, (GridInvokeValue)val0);
                        this.values[i] = val0;
                    } else {
                        if (this.addDepInfo) {
                            this.prepareObject(val, cctx);
                        }
                        val0 = cctx.toCacheObject(val);
                        assert (val0 != null);
                        val0.prepareMarshal(objCtx);
                        this.values[i] = val0;
                    }
                }
                ++i;
            }
        }
        if (this.filter != null) {
            this.filter.prepareMarshal(cctx);
        }
    }

    private void prepareInvokeValue(GridCacheContext cctx, GridInvokeValue val0) throws IgniteCheckedException {
        assert (val0 != null && this.addDepInfo);
        this.prepareObject(val0.entryProcessor(), cctx.shared());
        for (Object o : val0.invokeArgs()) {
            this.prepareObject(o, cctx.shared());
        }
        val0.prepareMarshal(cctx);
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.keys != null) {
            this.rows = new ArrayList<Object>(this.keys.length);
            CacheObjectContext objCtx = ctx.cacheContext(this.cacheId).cacheObjectContext();
            for (int i = 0; i < this.keys.length; ++i) {
                this.keys[i].finishUnmarshal(objCtx, ldr);
                if (this.op.isDeleteOrLock()) {
                    this.rows.add(this.keys[i]);
                    continue;
                }
                if (this.values[i] != null) {
                    if (this.op.isInvoke()) {
                        ((GridInvokeValue)this.values[i]).finishUnmarshal(ctx, ldr);
                    } else {
                        ((CacheObject)this.values[i]).finishUnmarshal(objCtx, ldr);
                    }
                }
                this.rows.add(new IgniteBiTuple<KeyCacheObject, Message>(this.keys[i], this.values[i]));
            }
            this.keys = null;
            this.values = null;
        }
        if (this.filter != null) {
            this.filter.finishUnmarshal(ctx.cacheContext(this.cacheId), ldr);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeBoolean("clientFirst", this.clientFirst)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeMessage("filter", this.filter)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeIgniteUuid("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeBoolean("keepBinary", this.keepBinary)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeObjectArray("keys", this.keys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeMessage("lockVer", this.lockVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeInt("miniId", this.miniId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeMessage("mvccSnapshot", this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeBoolean("needRes", this.needRes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeByte("op", this.op != null ? (byte)this.op.ordinal() : (byte)-1)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeUuid("subjId", this.subjId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeInt("taskNameHash", this.taskNameHash)) {
                    return false;
                }
                writer.incrementState();
            }
            case 16: {
                if (!writer.writeLong("threadId", this.threadId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 17: {
                if (!writer.writeLong("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 18: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 19: {
                if (!writer.writeLong("txTimeout", this.txTimeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 20: {
                if (!writer.writeObjectArray("values", this.values, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.clientFirst = reader.readBoolean("clientFirst");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.filter = (CacheEntryPredicate)reader.readMessage("filter");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.futId = reader.readIgniteUuid("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.keepBinary = reader.readBoolean("keepBinary");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.keys = reader.readObjectArray("keys", MessageCollectionItemType.MSG, KeyCacheObject.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.lockVer = (GridCacheVersion)reader.readMessage("lockVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.miniId = reader.readInt("miniId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.needRes = reader.readBoolean("needRes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                byte opOrd = reader.readByte("op");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.op = EnlistOperation.fromOrdinal(opOrd);
                reader.incrementState();
            }
            case 14: {
                this.subjId = reader.readUuid("subjId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.taskNameHash = reader.readInt("taskNameHash");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 16: {
                this.threadId = reader.readLong("threadId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 17: {
                this.timeout = reader.readLong("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 18: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 19: {
                this.txTimeout = reader.readLong("txTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 20: {
                this.values = reader.readObjectArray("values", MessageCollectionItemType.MSG, Message.class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearTxEnlistRequest.class);
    }

    @Override
    public byte fieldsCount() {
        return 21;
    }

    @Override
    public boolean addDeploymentInfo() {
        return this.addDepInfo;
    }

    @Override
    public short directType() {
        return 159;
    }

    @Override
    public String toString() {
        return S.toString(GridNearTxEnlistRequest.class, this);
    }
}

