/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near.consistency;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.EntryGetResult;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheExpiryPolicy;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridPartitionedGetFuture;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public abstract class GridNearReadRepairAbstractFuture
extends GridFutureAdapter<Map<KeyCacheObject, EntryGetResult>> {
    public static final int DFLT_MAX_REMAP_CNT = 3;
    protected static final int MAX_REMAP_CNT = IgniteSystemProperties.getInteger("IGNITE_NEAR_GET_MAX_REMAPS", 3);
    protected static final AtomicIntegerFieldUpdater<GridNearReadRepairAbstractFuture> REMAP_CNT_UPD = AtomicIntegerFieldUpdater.newUpdater(GridNearReadRepairAbstractFuture.class, "remapCnt");
    protected volatile int remapCnt;
    protected final Map<ClusterNode, GridPartitionedGetFuture<KeyCacheObject, EntryGetResult>> futs = new ConcurrentHashMap<ClusterNode, GridPartitionedGetFuture<KeyCacheObject, EntryGetResult>>();
    protected final GridCacheContext<KeyCacheObject, EntryGetResult> ctx;
    protected final Collection<KeyCacheObject> keys;
    protected final boolean readThrough;
    protected final String taskName;
    protected final boolean deserializeBinary;
    protected final boolean recovery;
    protected final IgniteCacheExpiryPolicy expiryPlc;
    protected final IgniteInternalTx tx;
    private final boolean canRemap;
    private AffinityTopologyVersion topVer;

    protected GridNearReadRepairAbstractFuture(AffinityTopologyVersion topVer, GridCacheContext<KeyCacheObject, EntryGetResult> ctx, Collection<KeyCacheObject> keys, boolean readThrough, String taskName, boolean deserializeBinary, boolean recovery, IgniteCacheExpiryPolicy expiryPlc, IgniteInternalTx tx) {
        this.ctx = ctx;
        this.keys = keys;
        this.readThrough = readThrough;
        this.taskName = taskName;
        this.deserializeBinary = deserializeBinary;
        this.recovery = recovery;
        this.expiryPlc = expiryPlc;
        this.tx = tx;
        this.canRemap = topVer == null;
        this.map(this.canRemap ? ctx.affinity().affinityTopologyVersion() : topVer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void map(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        this.futs.clear();
        IgniteInternalTx prevTx = this.ctx.tm().tx(this.tx);
        try {
            HashMap<ClusterNode, Collection> mappings = new HashMap<ClusterNode, Collection>();
            for (KeyCacheObject keyCacheObject : this.keys) {
                List<ClusterNode> nodes = this.ctx.affinity().nodesByKey(keyCacheObject, topVer);
                for (ClusterNode node : nodes) {
                    mappings.computeIfAbsent(node, k -> new HashSet()).add(keyCacheObject);
                }
            }
            for (Map.Entry entry : mappings.entrySet()) {
                ClusterNode node = (ClusterNode)entry.getKey();
                GridPartitionedGetFuture<KeyCacheObject, EntryGetResult> fut = new GridPartitionedGetFuture<KeyCacheObject, EntryGetResult>(this.ctx, (Collection)entry.getValue(), this.readThrough, false, this.tx != null ? this.tx.subjectId() : null, this.taskName, this.deserializeBinary, this.recovery, this.expiryPlc, false, true, true, this.tx != null ? this.tx.label() : null, this.tx != null ? this.tx.mvccSnapshot() : null, node);
                fut.listen(this::onResult);
                this.futs.put((ClusterNode)entry.getKey(), fut);
            }
            for (GridPartitionedGetFuture gridPartitionedGetFuture : this.futs.values()) {
                gridPartitionedGetFuture.init(topVer);
            }
            if (this.futs.isEmpty()) {
                this.onDone(new ClusterTopologyServerNotFoundException("Failed to map keys for cache (all partition nodes left the grid) [topVer=" + topVer + ", cache=" + this.ctx.name() + ']'));
            }
        }
        finally {
            this.ctx.tm().tx(prevTx);
        }
    }

    protected synchronized void onResult(IgniteInternalFuture<Map<KeyCacheObject, EntryGetResult>> finished) {
        if (this.isDone() || this.topVer == null) {
            return;
        }
        if (finished.error() != null) {
            if (finished.error() instanceof ClusterTopologyServerNotFoundException) {
                if (REMAP_CNT_UPD.incrementAndGet(this) > MAX_REMAP_CNT) {
                    this.onDone(new ClusterTopologyCheckedException("Failed to remap keys to a new nodes after " + MAX_REMAP_CNT + " attempts (keys got remapped to the same node) ]"));
                } else if (!this.canRemap) {
                    this.map(this.topVer);
                } else {
                    long maxTopVer = Math.max(this.topVer.topologyVersion() + 1L, this.ctx.discovery().topologyVersion());
                    AffinityTopologyVersion awaitTopVer = new AffinityTopologyVersion(maxTopVer);
                    this.topVer = null;
                    this.ctx.shared().exchange().affinityReadyFuture(awaitTopVer).listen(f -> this.map(awaitTopVer));
                }
            } else {
                this.onDone(finished.error());
            }
            return;
        }
        for (IgniteInternalFuture igniteInternalFuture : this.futs.values()) {
            if (igniteInternalFuture.isDone() && igniteInternalFuture.error() == null) continue;
            return;
        }
        this.reduce();
    }

    protected abstract void reduce();
}

