/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsInvalidRangeException;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsFileMap
implements Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private List<IgfsFileAffinityRange> ranges;

    public IgfsFileMap() {
    }

    public IgfsFileMap(@Nullable IgfsFileMap old) {
        if (old != null && old.ranges != null) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>(old.ranges.size());
            this.ranges.addAll(old.ranges);
        }
    }

    public IgniteUuid affinityKey(long blockOff, boolean includeMoved) {
        if (this.ranges == null) {
            return null;
        }
        assert (!this.ranges.isEmpty());
        int leftIdx = 0;
        int rightIdx = this.ranges.size() - 1;
        IgfsFileAffinityRange leftRange = this.ranges.get(leftIdx);
        IgfsFileAffinityRange rightRange = this.ranges.get(rightIdx);
        if (leftRange.less(blockOff)) {
            return null;
        }
        if (leftRange.belongs(blockOff)) {
            return leftRange.status() != 2 ? leftRange.affinityKey() : (includeMoved ? leftRange.affinityKey() : null);
        }
        if (rightRange.greater(blockOff)) {
            return null;
        }
        if (rightRange.belongs(blockOff)) {
            return rightRange.status() != 2 ? rightRange.affinityKey() : (includeMoved ? leftRange.affinityKey() : null);
        }
        while (rightIdx - leftIdx > 1) {
            int midIdx = (leftIdx + rightIdx) / 2;
            IgfsFileAffinityRange midRange = this.ranges.get(midIdx);
            if (midRange.belongs(blockOff)) {
                return midRange.status() != 2 ? midRange.affinityKey() : (includeMoved ? leftRange.affinityKey() : null);
            }
            if (midRange.less(blockOff)) {
                rightIdx = midIdx;
                continue;
            }
            assert (midRange.greater(blockOff));
            leftIdx = midIdx;
        }
        return null;
    }

    public void updateRangeStatus(IgfsFileAffinityRange range, int status) {
        if (this.ranges == null) {
            throw new IgfsInvalidRangeException("Failed to update range status (file map is empty) [range=" + range + ", ranges=null]");
        }
        assert (!this.ranges.isEmpty());
        int lastIdx = this.ranges.size() - 1;
        IgfsFileAffinityRange last = this.ranges.get(lastIdx);
        if (last.startOffset() == range.startOffset()) {
            this.updateRangeStatus0(lastIdx, last, range, status);
            return;
        }
        int firstIdx = 0;
        IgfsFileAffinityRange first = this.ranges.get(firstIdx);
        if (first.startOffset() == range.startOffset()) {
            this.updateRangeStatus0(firstIdx, first, range, status);
            return;
        }
        while (lastIdx - firstIdx > 1) {
            int midIdx = (firstIdx + lastIdx) / 2;
            IgfsFileAffinityRange midRange = this.ranges.get(midIdx);
            if (midRange.startOffset() == range.startOffset()) {
                this.updateRangeStatus0(midIdx, midRange, range, status);
                return;
            }
            if (midRange.less(range.startOffset())) {
                lastIdx = midIdx;
                continue;
            }
            assert (midRange.greater(range.startOffset()));
            firstIdx = midIdx;
        }
        throw new IgfsInvalidRangeException("Failed to update map for range (corresponding map range was not found) [range=" + range + ", status=" + status + ", ranges=" + this.ranges + ']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRange(IgfsFileAffinityRange range) {
        if (this.ranges == null) {
            throw new IgfsInvalidRangeException("Failed to remove range (file map is empty) [range=" + range + ", ranges=null]");
        }
        assert (!this.ranges.isEmpty());
        try {
            int lastIdx = this.ranges.size() - 1;
            IgfsFileAffinityRange last = this.ranges.get(lastIdx);
            if (last.regionEqual(range)) {
                assert (last.status() == 2);
                this.ranges.remove(last);
                return;
            }
            int firstIdx = 0;
            IgfsFileAffinityRange first = this.ranges.get(firstIdx);
            if (first.regionEqual(range)) {
                assert (first.status() == 2);
                this.ranges.remove(first);
                return;
            }
            while (lastIdx - firstIdx > 1) {
                int midIdx = (firstIdx + lastIdx) / 2;
                IgfsFileAffinityRange midRange = this.ranges.get(midIdx);
                if (midRange.regionEqual(range)) {
                    assert (midRange.status() == 2);
                    this.ranges.remove(midIdx);
                    return;
                }
                if (midRange.less(range.startOffset())) {
                    lastIdx = midIdx;
                    continue;
                }
                assert (midRange.greater(range.startOffset()));
                firstIdx = midIdx;
            }
        }
        finally {
            if (this.ranges.isEmpty()) {
                this.ranges = null;
            }
        }
        throw new IgfsInvalidRangeException("Failed to remove range from file map (corresponding map range was not found) [range=" + range + ", ranges=" + this.ranges + ']');
    }

    private void updateRangeStatus0(int origIdx, IgfsFileAffinityRange orig, IgfsFileAffinityRange update, int status) {
        assert (F.eq(orig.affinityKey(), update.affinityKey()));
        assert (this.ranges.get(origIdx) == orig);
        if (orig.regionEqual(update)) {
            this.ranges.set(origIdx, new IgfsFileAffinityRange(update, status));
        } else {
            assert (orig.endOffset() > update.endOffset());
            this.ranges.set(origIdx, new IgfsFileAffinityRange(update, status));
            this.ranges.add(origIdx + 1, new IgfsFileAffinityRange(update.endOffset() + 1L, orig.endOffset(), orig.affinityKey()));
        }
    }

    public List<IgfsFileAffinityRange> ranges() {
        if (this.ranges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.ranges);
    }

    public void addRange(IgfsFileAffinityRange range) {
        if (range == null || range.empty()) {
            return;
        }
        if (this.ranges == null) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>();
            this.ranges.add(range);
            return;
        }
        assert (!this.ranges.isEmpty());
        IgfsFileAffinityRange last = this.ranges.get(this.ranges.size() - 1);
        assert (last.greater(range.startOffset())) : "Cannot add range to middle of map [last=" + last + ", range=" + range + ']';
        IgfsFileAffinityRange concat = last.concat(range);
        if (concat == null) {
            this.ranges.add(range);
        } else {
            this.ranges.set(this.ranges.size() - 1, concat);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.ranges == null) {
            out.writeInt(-1);
        } else {
            assert (!this.ranges.isEmpty());
            out.writeInt(this.ranges.size());
            for (IgfsFileAffinityRange range : this.ranges) {
                out.writeObject(range);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        if (size > 0) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>(size);
            for (int i = 0; i < size; ++i) {
                this.ranges.add((IgfsFileAffinityRange)in.readObject());
            }
        }
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        if (this.ranges == null) {
            out.writeInt(-1);
        } else {
            assert (!this.ranges.isEmpty());
            out.writeInt(this.ranges.size());
            for (IgfsFileAffinityRange range : this.ranges) {
                out.writeObject(range);
            }
        }
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        int size = in.readInt();
        if (size > 0) {
            this.ranges = new ArrayList<IgfsFileAffinityRange>(size);
            for (int i = 0; i < size; ++i) {
                this.ranges.add((IgfsFileAffinityRange)in.readObject());
            }
        }
    }

    public String toString() {
        return S.toString(IgfsFileMap.class, this);
    }
}

