/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.IgniteException;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsListingEntry;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

public final class IgfsMetaDirectoryListingAddProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, Void>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private String fileName;
    private IgfsListingEntry entry;

    public IgfsMetaDirectoryListingAddProcessor() {
    }

    public IgfsMetaDirectoryListingAddProcessor(String fileName, IgfsListingEntry entry) {
        assert (fileName != null);
        assert (entry != null);
        this.fileName = fileName;
        this.entry = entry;
    }

    @Override
    public Void process(MutableEntry<IgniteUuid, IgfsEntryInfo> e, Object ... args) {
        IgfsEntryInfo fileInfo = (IgfsEntryInfo)e.getValue();
        assert (fileInfo != null && fileInfo.isDirectory()) : fileInfo;
        HashMap<String, IgfsListingEntry> listing = new HashMap<String, IgfsListingEntry>(fileInfo.listing());
        IgfsListingEntry oldEntry = listing.put(this.fileName, this.entry);
        if (oldEntry != null && !oldEntry.fileId().equals(this.entry.fileId())) {
            throw new IgniteException("Directory listing contains unexpected file [listing=" + listing + ", fileName=" + this.fileName + ", entry=" + this.entry + ", oldEntry=" + oldEntry + ']');
        }
        e.setValue(fileInfo.listing(listing));
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString(out, this.fileName);
        IgfsUtils.writeListingEntry(out, this.entry);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fileName = U.readString(in);
        this.entry = IgfsUtils.readListingEntry(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeString(this.fileName);
        IgfsUtils.writeListingEntry(out, this.entry);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.fileName = in.readString();
        this.entry = IgfsUtils.readListingEntry(in);
    }

    public String toString() {
        return S.toString(IgfsMetaDirectoryListingAddProcessor.class, this);
    }
}

