/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsFileAffinityRange;
import org.apache.ignite.internal.processors.igfs.IgfsFileMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsMetaFileRangeUpdateProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, IgfsEntryInfo>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private IgfsFileAffinityRange range;
    private int status;

    public IgfsMetaFileRangeUpdateProcessor() {
    }

    public IgfsMetaFileRangeUpdateProcessor(IgfsFileAffinityRange range, int status) {
        this.range = range;
        this.status = status;
    }

    @Override
    public IgfsEntryInfo process(MutableEntry<IgniteUuid, IgfsEntryInfo> entry, Object ... args) throws EntryProcessorException {
        IgfsEntryInfo oldInfo = (IgfsEntryInfo)entry.getValue();
        IgfsFileMap newMap = new IgfsFileMap(oldInfo.fileMap());
        newMap.updateRangeStatus(this.range, this.status);
        IgfsEntryInfo newInfo = oldInfo.fileMap(newMap);
        entry.setValue(newInfo);
        return newInfo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.range);
        out.writeInt(this.status);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.range = (IgfsFileAffinityRange)in.readObject();
        this.status = in.readInt();
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeObject(this.range);
        out.writeInt(this.status);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.range = (IgfsFileAffinityRange)in.readObject();
        this.status = in.readInt();
    }

    public String toString() {
        return S.toString(IgfsMetaFileRangeUpdateProcessor.class, this);
    }
}

