/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.processors.igfs.IgfsEntryInfo;
import org.apache.ignite.internal.processors.igfs.IgfsUtils;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;

public class IgfsMetaUpdatePropertiesProcessor
implements EntryProcessor<IgniteUuid, IgfsEntryInfo, IgfsEntryInfo>,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    private Map<String, String> props;

    public IgfsMetaUpdatePropertiesProcessor() {
    }

    public IgfsMetaUpdatePropertiesProcessor(Map<String, String> props) {
        this.props = props;
    }

    @Override
    public IgfsEntryInfo process(MutableEntry<IgniteUuid, IgfsEntryInfo> entry, Object ... args) throws EntryProcessorException {
        IgfsEntryInfo oldInfo = (IgfsEntryInfo)entry.getValue();
        GridLeanMap<String, String> tmp = oldInfo.properties();
        tmp = tmp == null ? new GridLeanMap<String, String>(this.props.size()) : new GridLeanMap<String, String>(tmp);
        for (Map.Entry<String, String> e : this.props.entrySet()) {
            if (e.getValue() == null) {
                tmp.remove(e.getKey());
                continue;
            }
            tmp.put(e.getKey(), e.getValue());
        }
        IgfsEntryInfo newInfo = oldInfo.properties(tmp);
        entry.setValue(newInfo);
        return newInfo;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IgfsUtils.writeProperties(out, this.props);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.props = IgfsUtils.readProperties(in);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        IgfsUtils.writeProperties(out, this.props);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.props = IgfsUtils.readProperties(in);
    }

    public String toString() {
        return S.toString(IgfsMetaUpdatePropertiesProcessor.class, this);
    }
}

