/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metric.impl;

import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.spi.metric.HistogramMetric;

public class MetricUtils {
    public static final String SEPARATOR = ".";
    public static final String INF = "_inf";
    public static final char HISTOGRAM_NAME_DIVIDER = '_';

    public static String metricName(String ... names) {
        assert (names != null);
        assert (MetricUtils.ensureAllNamesNotEmpty(names));
        if (names.length == 1) {
            return names[0];
        }
        return String.join((CharSequence)SEPARATOR, names);
    }

    public static T2<String, String> fromFullName(String name) {
        return new T2<String, String>(name.substring(0, name.lastIndexOf(SEPARATOR)), name.substring(name.lastIndexOf(SEPARATOR) + 1));
    }

    public static String cacheMetricsRegistryName(String cacheName, boolean isNear) {
        if (isNear) {
            return MetricUtils.metricName("cache", cacheName, "near");
        }
        return MetricUtils.metricName("cache", cacheName);
    }

    public static boolean compareAndSet(AtomicLongMetric m, long expect, long update) {
        return AtomicLongMetric.updater.compareAndSet(m, expect, update);
    }

    public static void setIfLess(AtomicLongMetric m, long update) {
        long v = m.value();
        while (v > update && !AtomicLongMetric.updater.compareAndSet(m, v, update)) {
            v = m.value();
        }
    }

    public static void setIfGreater(AtomicLongMetric m, long update) {
        long v = m.value();
        while (v < update && !AtomicLongMetric.updater.compareAndSet(m, v, update)) {
            v = m.value();
        }
    }

    private static boolean ensureAllNamesNotEmpty(String ... names) {
        for (int i = 0; i < names.length; ++i) {
            assert (names[i] != null && !names[i].isEmpty()) : i + " element is empty [" + String.join((CharSequence)".", names) + "]";
        }
        return true;
    }

    public static String[] histogramBucketNames(HistogramMetric metric) {
        String name = metric.name();
        long[] bounds = metric.bounds();
        String[] names = new String[bounds.length + 1];
        long min = 0L;
        for (int i = 0; i < bounds.length; ++i) {
            names[i] = name + '_' + min + '_' + bounds[i];
            min = bounds[i];
        }
        names[bounds.length] = name + '_' + min + INF;
        return names;
    }
}

