/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcCachePartitionsRequest
extends JdbcRequest {
    private Set<Integer> cacheIds;

    public JdbcCachePartitionsRequest() {
        super((byte)16);
    }

    public JdbcCachePartitionsRequest(Set<Integer> cacheIds) {
        super((byte)16);
        this.cacheIds = cacheIds;
    }

    public Set<Integer> cacheIds() {
        return Collections.unmodifiableSet(this.cacheIds);
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        assert (this.cacheIds != null);
        assert (!this.cacheIds.isEmpty());
        writer.writeInt(this.cacheIds.size());
        for (Integer cacheId : this.cacheIds) {
            writer.writeInt(cacheId);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        int cacheIdsSize = reader.readInt();
        this.cacheIds = new HashSet<Integer>();
        for (int i = 0; i < cacheIdsSize; ++i) {
            this.cacheIds.add(reader.readInt());
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcCachePartitionsRequest.class, this);
    }
}

