/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.jdbc.thin.JdbcThinUtils;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcColumnMeta
implements JdbcRawBinarylizable {
    private String schemaName;
    private String tblName;
    private String colName;
    private int dataType;
    private String dataTypeName;
    private String dataTypeClass;

    JdbcColumnMeta() {
    }

    JdbcColumnMeta(GridQueryFieldMetadata info) {
        this.schemaName = info.schemaName();
        this.tblName = info.typeName();
        this.colName = info.fieldName();
        this.dataType = JdbcThinUtils.type(info.fieldTypeName());
        this.dataTypeName = JdbcThinUtils.typeName(info.fieldTypeName());
        this.dataTypeClass = info.fieldTypeName();
    }

    public JdbcColumnMeta(String schemaName, String tblName, String colName, Class<?> cls) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.colName = colName;
        String type = cls.getName();
        this.dataType = JdbcThinUtils.type(type);
        this.dataTypeName = JdbcThinUtils.typeName(type);
        this.dataTypeClass = type;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String columnName() {
        return this.colName;
    }

    public int dataType() {
        return this.dataType;
    }

    public String dataTypeName() {
        return this.dataTypeName;
    }

    public String dataTypeClass() {
        return this.dataTypeClass;
    }

    public String defaultValue() {
        return null;
    }

    public int precision() {
        return -1;
    }

    public int scale() {
        return -1;
    }

    public boolean isNullable() {
        return JdbcUtils.nullable(this.colName, this.dataTypeClass);
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) {
        writer.writeString(this.schemaName);
        writer.writeString(this.tblName);
        writer.writeString(this.colName);
        writer.writeInt(this.dataType);
        writer.writeString(this.dataTypeName);
        writer.writeString(this.dataTypeClass);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) {
        this.schemaName = reader.readString();
        this.tblName = reader.readString();
        this.colName = reader.readString();
        this.dataType = reader.readInt();
        this.dataTypeName = reader.readString();
        this.dataTypeClass = reader.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcColumnMeta meta = (JdbcColumnMeta)o;
        return F.eq(this.schemaName, meta.schemaName) && F.eq(this.tblName, meta.tblName) && F.eq(this.colName, meta.colName);
    }

    public int hashCode() {
        int result = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result = 31 * result + (this.tblName != null ? this.tblName.hashCode() : 0);
        result = 31 * result + this.colName.hashCode();
        return result;
    }

    public String toString() {
        return S.toString(JdbcColumnMeta.class, this);
    }
}

