/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaColumnsResult
extends JdbcResult {
    private List<JdbcColumnMeta> meta;

    JdbcMetaColumnsResult() {
        super((byte)8);
    }

    JdbcMetaColumnsResult(Collection<JdbcColumnMeta> meta) {
        super((byte)8);
        this.meta = new ArrayList<JdbcColumnMeta>(meta);
    }

    protected JdbcMetaColumnsResult(byte type) {
        super(type);
    }

    protected JdbcMetaColumnsResult(byte type, Collection<JdbcColumnMeta> meta) {
        super(type);
        this.meta = new ArrayList<JdbcColumnMeta>(meta);
    }

    public List<JdbcColumnMeta> meta() {
        return this.meta;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        if (F.isEmpty(this.meta)) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.meta.size());
            for (JdbcColumnMeta m : this.meta) {
                m.writeBinary(writer, ver);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        int size = reader.readInt();
        if (size == 0) {
            this.meta = Collections.emptyList();
        } else {
            this.meta = new ArrayList<JdbcColumnMeta>(size);
            for (int i = 0; i < size; ++i) {
                JdbcColumnMeta m = this.createMetaColumn();
                m.readBinary(reader, ver);
                this.meta.add(m);
            }
        }
    }

    protected JdbcColumnMeta createMetaColumn() {
        return new JdbcColumnMeta();
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaColumnsResult.class, this);
    }
}

