/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcMetaTablesRequest
extends JdbcRequest {
    private String schemaName;
    private String tblName;
    private String[] tblTypes;

    JdbcMetaTablesRequest() {
        super((byte)7);
    }

    public JdbcMetaTablesRequest(String schemaName, String tblName, String[] tblTypes) {
        super((byte)7);
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.tblTypes = tblTypes;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String[] tableTypes() {
        return this.tblTypes;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.writeBinary(writer, ver);
        writer.writeString(this.schemaName);
        writer.writeString(this.tblName);
        if (ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0) {
            writer.writeStringArray(this.tblTypes);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        super.readBinary(reader, ver);
        this.schemaName = reader.readString();
        this.tblName = reader.readString();
        if (ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0) {
            this.tblTypes = reader.readStringArray();
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaTablesRequest.class, this);
    }
}

