/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.Objects;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.ClientListenerProtocolVersion;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcConnectionContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcTableMeta
implements JdbcRawBinarylizable {
    private String schemaName;
    private String tblName;
    private String tblType;

    JdbcTableMeta() {
        this.tblType = "TABLE";
    }

    JdbcTableMeta(String schemaName, String tblName, String tblType) {
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.tblType = tblType;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String tableType() {
        return this.tblType;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        writer.writeString(this.schemaName);
        writer.writeString(this.tblName);
        if (ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0) {
            writer.writeString(this.tblType);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, ClientListenerProtocolVersion ver) throws BinaryObjectException {
        this.schemaName = reader.readString();
        this.tblName = reader.readString();
        if (ver.compareTo(JdbcConnectionContext.VER_2_8_0) >= 0) {
            this.tblType = reader.readString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcTableMeta meta = (JdbcTableMeta)o;
        return F.eq(this.schemaName, meta.schemaName) && F.eq(this.tblName, meta.tblName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tblName);
    }

    public String toString() {
        return S.toString(JdbcTableMeta.class, this);
    }
}

