/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.nio.GridNioException;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioParser;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteInClosure;

public class GridNioCodecFilter
extends GridNioFilterAdapter {
    private GridNioParser parser;
    @GridToStringExclude
    private IgniteLogger log;
    private boolean directMode;

    public GridNioCodecFilter(GridNioParser parser, IgniteLogger log, boolean directMode) {
        super("GridNioCodecFilter");
        this.parser = parser;
        this.log = log;
        this.directMode = directMode;
    }

    @Override
    public String toString() {
        return S.toString(GridNioCodecFilter.class, this);
    }

    @Override
    public void onSessionOpened(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionOpened(ses);
    }

    @Override
    public void onSessionClosed(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionClosed(ses);
    }

    @Override
    public void onExceptionCaught(GridNioSession ses, IgniteCheckedException ex) throws IgniteCheckedException {
        this.proceedExceptionCaught(ses, ex);
    }

    @Override
    public GridNioFuture<?> onSessionWrite(GridNioSession ses, Object msg, boolean fut, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        if (this.directMode) {
            return this.proceedSessionWrite(ses, msg, fut, ackC);
        }
        try {
            ByteBuffer res = this.parser.encode(ses, msg);
            return this.proceedSessionWrite(ses, res, fut, ackC);
        }
        catch (IOException e) {
            throw new GridNioException(e);
        }
    }

    @Override
    public void onMessageReceived(GridNioSession ses, Object msg) throws IgniteCheckedException {
        if (!(msg instanceof ByteBuffer)) {
            throw new GridNioException("Failed to decode incoming message (incoming message is not a byte buffer, is filter properly placed?): " + msg.getClass());
        }
        try {
            ByteBuffer input = (ByteBuffer)msg;
            while (input.hasRemaining()) {
                Object res = this.parser.decode(ses, input);
                if (res != null) {
                    this.proceedMessageReceived(ses, res);
                    continue;
                }
                if (!input.hasRemaining()) continue;
                if (this.directMode) {
                    return;
                }
                LT.warn(this.log, "Parser returned null but there are still unread data in input buffer (bug in parser code?) [parser=" + this.parser + ", ses=" + ses + ']');
                input.position(input.limit());
            }
        }
        catch (IOException e) {
            throw new GridNioException(e);
        }
    }

    @Override
    public GridNioFuture<Boolean> onSessionClose(GridNioSession ses) throws IgniteCheckedException {
        return this.proceedSessionClose(ses);
    }

    @Override
    public void onSessionIdleTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionIdleTimeout(ses);
    }

    @Override
    public void onSessionWriteTimeout(GridNioSession ses) throws IgniteCheckedException {
        this.proceedSessionWriteTimeout(ses);
    }
}

