/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.messages;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.discovery.CustomMessageWrapper;
import org.apache.ignite.internal.managers.discovery.IncompleteDeserializationException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoverySpiCustomMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryAbstractMessage;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryEnsureDelivery;
import org.apache.ignite.spi.discovery.tcp.messages.TcpDiscoveryRedirectToClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TcpDiscoveryRedirectToClient
@TcpDiscoveryEnsureDelivery
public class TcpDiscoveryCustomEventMessage
extends TcpDiscoveryAbstractMessage {
    private static final long serialVersionUID = 0L;
    private volatile transient DiscoverySpiCustomMessage msg;
    private byte[] msgBytes;

    public TcpDiscoveryCustomEventMessage(UUID creatorNodeId, @Nullable DiscoverySpiCustomMessage msg, @NotNull byte[] msgBytes) {
        super(creatorNodeId);
        this.msg = msg;
        this.msgBytes = msgBytes;
    }

    public TcpDiscoveryCustomEventMessage(TcpDiscoveryCustomEventMessage msg) {
        super(msg);
        this.msgBytes = msg.msgBytes;
        this.msg = msg.msg;
    }

    public void clearMessage() {
        this.msg = null;
    }

    public byte[] messageBytes() {
        return this.msgBytes;
    }

    public void message(@Nullable DiscoverySpiCustomMessage msg, @NotNull byte[] msgBytes) {
        this.msg = msg;
        this.msgBytes = msgBytes;
    }

    @Nullable
    public DiscoverySpiCustomMessage message(@NotNull Marshaller marsh, ClassLoader ldr) throws Throwable {
        if (this.msg == null) {
            try {
                this.msg = (DiscoverySpiCustomMessage)U.unmarshal(marsh, this.msgBytes, ldr);
            }
            catch (IgniteCheckedException e) {
                if (e.getCause() instanceof IncompleteDeserializationException) {
                    return new CustomMessageWrapper(((IncompleteDeserializationException)e.getCause()).message());
                }
                throw e;
            }
            assert (this.msg != null);
        }
        return this.msg;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof TcpDiscoveryCustomEventMessage && F.eq(((TcpDiscoveryCustomEventMessage)obj).verifierNodeId(), this.verifierNodeId());
    }

    @Override
    public String toString() {
        return S.toString(TcpDiscoveryCustomEventMessage.class, this, "super", super.toString());
    }
}

