/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.filter;

import java.util.ArrayList;
import org.netcrusher.core.filter.TransformFilter;
import org.netcrusher.core.filter.TransformFilterFactory;

public final class TransformFilters {
    private TransformFilters() {
    }

    public static TransformFilterFactory all(TransformFilterFactory ... filterFactories) {
        if (filterFactories == null || filterFactories.length == 0) {
            throw new IllegalArgumentException("Filter array is empty");
        }
        return clientAddress -> {
            ArrayList<TransformFilter> filters = new ArrayList<TransformFilter>(filterFactories.length);
            for (TransformFilterFactory factory : filterFactories) {
                filters.add(factory.allocate(clientAddress));
            }
            return bb -> {
                for (TransformFilter filter : filters) {
                    filter.transform(bb);
                }
            };
        };
    }
}

