/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.reactor;

import java.io.Closeable;
import java.io.IOException;
import org.netcrusher.core.reactor.NioScheduler;
import org.netcrusher.core.reactor.NioSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioReactor
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioReactor.class);
    private static final long DEFAULT_TICK_MS = 20L;
    private final NioSelector selector;
    private final NioScheduler scheduler;
    private volatile boolean open;

    public NioReactor() throws IOException {
        this(20L);
    }

    public NioReactor(long tickMs) throws IOException {
        this.selector = new NioSelector(tickMs);
        this.scheduler = new NioScheduler();
        this.open = true;
        LOGGER.debug("Reactor has been created with tick={}ms", (Object)tickMs);
    }

    @Override
    public synchronized void close() {
        if (this.open) {
            this.selector.close();
            this.scheduler.close();
            this.open = false;
            LOGGER.debug("Reactor is closed");
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public NioSelector getSelector() {
        return this.selector;
    }

    public NioScheduler getScheduler() {
        return this.scheduler;
    }
}

