/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.core.reactor;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NioSelectorPostOp<T>
implements Runnable {
    private final CompletableFuture<T> future;
    private final Callable<T> delegate;

    public NioSelectorPostOp(Callable<T> delegate) {
        this.delegate = delegate;
        this.future = new CompletableFuture();
    }

    @Override
    public void run() {
        try {
            T result = this.delegate.call();
            this.future.complete(result);
        }
        catch (Exception e) {
            this.future.completeExceptionally(e);
        }
    }

    public T await() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    public T await(long timeout, TimeUnit timeUnit) throws TimeoutException, InterruptedException, ExecutionException {
        return this.future.get(timeout, timeUnit);
    }
}

