/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.datagram;

import java.io.IOException;
import java.io.Serializable;
import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;

public class DatagramCrusherSocketOptions
implements Serializable {
    private int rcvBufferSize = 0;
    private int sndBufferSize = 0;
    private boolean broadcast = false;
    private ProtocolFamily protocolFamily = StandardProtocolFamily.INET;

    public DatagramCrusherSocketOptions copy() {
        DatagramCrusherSocketOptions copy = new DatagramCrusherSocketOptions();
        copy.rcvBufferSize = this.rcvBufferSize;
        copy.sndBufferSize = this.sndBufferSize;
        copy.broadcast = this.broadcast;
        copy.protocolFamily = this.protocolFamily;
        return copy;
    }

    public int getRcvBufferSize() {
        return this.rcvBufferSize;
    }

    public void setRcvBufferSize(int rcvBufferSize) {
        this.rcvBufferSize = rcvBufferSize;
    }

    public int getSndBufferSize() {
        return this.sndBufferSize;
    }

    public void setSndBufferSize(int sndBufferSize) {
        this.sndBufferSize = sndBufferSize;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public ProtocolFamily getProtocolFamily() {
        return this.protocolFamily;
    }

    public void setProtocolFamily(ProtocolFamily protocolFamily) {
        this.protocolFamily = protocolFamily;
    }

    void setupSocketChannel(DatagramChannel datagramChannel) throws IOException {
        datagramChannel.setOption((SocketOption)StandardSocketOptions.SO_BROADCAST, (Object)this.broadcast);
        if (this.rcvBufferSize > 0) {
            datagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.rcvBufferSize);
        }
        if (this.sndBufferSize > 0) {
            datagramChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.sndBufferSize);
        }
    }
}

