/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.datagram.main;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.netcrusher.core.filter.LoggingFilter;
import org.netcrusher.core.main.AbstractCrusherMain;
import org.netcrusher.core.meter.RateMeters;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.throttle.rate.ByteRateThrottler;
import org.netcrusher.core.throttle.rate.PacketRateThrottler;
import org.netcrusher.datagram.DatagramCrusher;
import org.netcrusher.datagram.DatagramCrusherBuilder;

public class DatagramCrusherMain
extends AbstractCrusherMain<DatagramCrusher> {
    private static final int DEFAULT_IDLE_PERIOD_SEC = 60;
    private static final String CMD_CLOSE_IDLE = "CLOSE-IDLE";

    @Override
    protected DatagramCrusher create(NioReactor reactor, InetSocketAddress bindAddress, InetSocketAddress connectAddress) {
        int byteRatePerSec;
        int packetRatePerSec;
        DatagramCrusherBuilder builder = DatagramCrusherBuilder.builder();
        builder.withReactor(reactor).withBindAddress(bindAddress).withConnectAddress(connectAddress);
        builder.withCreationListener(address -> LOGGER.info("Client for <{}> is created", (Object)address));
        builder.withDeletionListener((address, byteMeters, packetMeters) -> {
            LOGGER.info("Client for <{}> is deleted", (Object)address);
            this.statusClientMeters(byteMeters, packetMeters);
        });
        builder.withBufferCount(Integer.getInteger("crusher.buffer.count", 1024)).withBufferSize(Integer.getInteger("crusher.buffer.size", 8192));
        builder.withRcvBufferSize(Integer.getInteger("crusher.socket.rcvbuf.size", 0)).withSndBufferSize(Integer.getInteger("crusher.socket.sndbuf.size", 0));
        String loggerName = System.getProperty("crusher.logger", null);
        if (loggerName != null) {
            builder.withOutgoingTransformFilterFactory(addr -> new LoggingFilter(addr, loggerName + ".outgoing", LoggingFilter.Level.INFO));
            builder.withIncomingTransformFilterFactory(addr -> new LoggingFilter(addr, loggerName + ".incoming", LoggingFilter.Level.INFO));
        }
        if ((packetRatePerSec = Integer.getInteger("crusher.throttler.packets", 0).intValue()) > 0) {
            builder.withOutgoingThrottlerFactory(addr -> new PacketRateThrottler(packetRatePerSec, 1L, TimeUnit.SECONDS));
        }
        if ((byteRatePerSec = Integer.getInteger("crusher.throttler.bytes", 0).intValue()) > 0) {
            builder.withOutgoingThrottlerFactory(addr -> new ByteRateThrottler(byteRatePerSec, 1L, TimeUnit.SECONDS));
        }
        return builder.buildAndOpen();
    }

    @Override
    protected void printHelp() {
        super.printHelp();
        LOGGER.info("Commands for Datagram clients:");
        LOGGER.info("\tCLOSE-IDLE - close idle (> 60 sec) clients");
    }

    @Override
    protected void command(DatagramCrusher crusher, String command) {
        if (command.startsWith(CMD_CLOSE_IDLE)) {
            this.closeIdle(crusher);
        } else {
            super.command(crusher, command);
        }
    }

    private void closeIdle(DatagramCrusher crusher) {
        if (crusher.isOpen()) {
            int closed = crusher.closeIdleClients(60L, TimeUnit.SECONDS);
            LOGGER.info("Idle clients are closed: {}", (Object)closed);
        } else {
            LOGGER.warn("Crusher is not open");
        }
    }

    @Override
    protected void status(DatagramCrusher crusher) {
        super.status(crusher);
        if (crusher.isOpen()) {
            LOGGER.info("Inner statistics");
            RateMeters innerByteMeters = crusher.getInnerByteMeters();
            LOGGER.info("\ttotal read bytes: {}", (Object)innerByteMeters.getReadMeter().getTotal());
            LOGGER.info("\ttotal sent bytes: {}", (Object)innerByteMeters.getSentMeter().getTotal());
            RateMeters innerPacketMeters = crusher.getInnerPacketMeters();
            LOGGER.info("\ttotal read packets: {}", (Object)innerPacketMeters.getReadMeter().getTotal());
            LOGGER.info("\ttotal sent packets: {}", (Object)innerPacketMeters.getSentMeter().getTotal());
        }
    }

    @Override
    protected void statusClient(DatagramCrusher crusher, InetSocketAddress address) {
        RateMeters byteMeters = crusher.getClientByteMeters(address);
        RateMeters packetMeters = crusher.getClientPacketMeters(address);
        if (byteMeters != null && packetMeters != null) {
            LOGGER.info("Client statistics for <{}>", (Object)address);
            this.statusClientMeters(byteMeters, packetMeters);
        } else {
            LOGGER.warn("Client for <{}> is not found", (Object)address);
        }
    }

    private void statusClientMeters(RateMeters byteMeters, RateMeters packetMeters) {
        LOGGER.info("\ttotal read bytes: {}", (Object)byteMeters.getReadMeter().getTotal());
        LOGGER.info("\ttotal sent bytes: {}", (Object)byteMeters.getSentMeter().getTotal());
        LOGGER.info("\ttotal read packets: {}", (Object)packetMeters.getReadMeter().getTotal());
        LOGGER.info("\ttotal sent packets: {}", (Object)packetMeters.getSentMeter().getTotal());
    }

    public static void main(String[] arguments) throws Exception {
        DatagramCrusherMain main = new DatagramCrusherMain();
        main.run(arguments);
    }
}

