/*
 * Decompiled with CFR 0.152.
 */
package org.netcrusher.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.netcrusher.NetFreezer;
import org.netcrusher.core.buffer.BufferOptions;
import org.netcrusher.core.meter.RateMeters;
import org.netcrusher.core.reactor.NioReactor;
import org.netcrusher.core.state.BitState;
import org.netcrusher.tcp.TcpChannel;
import org.netcrusher.tcp.TcpFilters;
import org.netcrusher.tcp.TcpQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TcpPair
implements NetFreezer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpPair.class);
    private final TcpChannel innerChannel;
    private final TcpChannel outerChannel;
    private final Runnable ownerClose;
    private final NioReactor reactor;
    private final InetSocketAddress clientAddress;
    private final State state;

    TcpPair(NioReactor reactor, TcpFilters filters, SocketChannel inner, SocketChannel outer, BufferOptions bufferOptions, Runnable ownerClose) throws IOException {
        this.ownerClose = ownerClose;
        this.reactor = reactor;
        this.clientAddress = (InetSocketAddress)inner.getRemoteAddress();
        TcpQueue innerToOuter = TcpQueue.allocateQueue(this.clientAddress, bufferOptions, filters.getOutgoingTransformFilterFactory(), filters.getOutgoingThrottlerFactory());
        TcpQueue outerToInner = TcpQueue.allocateQueue(this.clientAddress, bufferOptions, filters.getIncomingTransformFilterFactory(), filters.getIncomingThrottlerFactory());
        this.innerChannel = new TcpChannel("INNER", reactor, this::closeAll, inner, outerToInner, innerToOuter);
        this.outerChannel = new TcpChannel("OUTER", reactor, this::closeAll, outer, innerToOuter, outerToInner);
        this.innerChannel.setOther(this.outerChannel);
        this.outerChannel.setOther(this.innerChannel);
        this.state = new State(State.FROZEN);
    }

    private void closeAll() {
        this.close();
        this.ownerClose.run();
    }

    void close() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.not(State.CLOSED)) {
                if (this.state.is(State.OPEN)) {
                    this.freeze();
                }
                this.innerChannel.close();
                this.outerChannel.close();
                this.state.set(State.CLOSED);
                LOGGER.debug("Pair for '{}' is closed", (Object)this.clientAddress);
                return true;
            }
            return false;
        });
    }

    @Override
    public void freeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.OPEN)) {
                if (!this.innerChannel.isFrozen()) {
                    this.innerChannel.freeze();
                }
                if (!this.outerChannel.isFrozen()) {
                    this.outerChannel.freeze();
                }
                this.state.set(State.FROZEN);
                return true;
            }
            throw new IllegalStateException("Pair is not open on freeze");
        });
    }

    @Override
    public void unfreeze() {
        this.reactor.getSelector().execute(() -> {
            if (this.state.is(State.FROZEN)) {
                if (this.innerChannel.isFrozen()) {
                    this.innerChannel.unfreeze();
                }
                if (this.outerChannel.isFrozen()) {
                    this.outerChannel.unfreeze();
                }
                this.state.set(State.OPEN);
                return true;
            }
            throw new IllegalStateException("Pair is not frozen on unfreeze");
        });
    }

    @Override
    public boolean isFrozen() {
        return this.state.isAnyOf(State.FROZEN | State.CLOSED);
    }

    InetSocketAddress getClientAddress() {
        return this.clientAddress;
    }

    RateMeters getByteMeters() {
        return new RateMeters(this.innerChannel.getSentBytesMeter(), this.outerChannel.getSentBytesMeter());
    }

    private static final class State
    extends BitState {
        private static final int OPEN = State.bit(0);
        private static final int FROZEN = State.bit(1);
        private static final int CLOSED = State.bit(2);

        private State(int state) {
            super(state);
        }
    }
}

