/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.cluster;

import org.apache.ignite.Ignite;
import org.terracotta.angela.common.clientconfig.ClientId;
import org.terracotta.angela.common.cluster.AtomicBoolean;
import org.terracotta.angela.common.cluster.AtomicCounter;
import org.terracotta.angela.common.cluster.AtomicReference;
import org.terracotta.angela.common.cluster.Barrier;

public class Cluster {
    private final Ignite ignite;
    private final ClientId clientId;

    public Cluster(Ignite ignite) {
        this(ignite, null);
    }

    public Cluster(Ignite ignite, ClientId clientId) {
        this.ignite = ignite;
        this.clientId = clientId;
    }

    public Barrier barrier(String name, int count) {
        return new Barrier(this.ignite, count, name);
    }

    public AtomicCounter atomicCounter(String name, long initialValue) {
        return new AtomicCounter(this.ignite, name, initialValue);
    }

    public AtomicBoolean atomicBoolean(String name, boolean initialValue) {
        return new AtomicBoolean(this.ignite, name, initialValue);
    }

    public <T> AtomicReference<T> atomicReference(String name, T initialValue) {
        return new AtomicReference<T>(this.ignite, name, initialValue);
    }

    public ClientId getClientId() {
        return this.clientId;
    }
}

