/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.tcconfig.holders;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.angela.common.net.PortAllocator;
import org.terracotta.angela.common.tcconfig.ServerSymbolicName;
import org.terracotta.angela.common.tcconfig.TerracottaServer;
import org.terracotta.angela.common.tcconfig.TsaStripeConfig;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class TcConfigHolder {
    private static final Logger logger = LoggerFactory.getLogger(TcConfigHolder.class);
    protected volatile String tcConfigContent;
    private volatile String installedTcConfigPath;
    private final List<String> logsPathList = new ArrayList<String>();
    private final List<TerracottaServer> servers = new ArrayList<TerracottaServer>();

    public TcConfigHolder() {
    }

    public TcConfigHolder(TcConfigHolder tcConfigHolder) {
        this.tcConfigContent = tcConfigHolder.tcConfigContent;
        this.installedTcConfigPath = tcConfigHolder.installedTcConfigPath;
        this.logsPathList.addAll(tcConfigHolder.logsPathList);
    }

    public TcConfigHolder(InputStream tcConfigInputStream) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document tcConfigXml = builder.parse(tcConfigInputStream);
            this.tcConfigContent = TcConfigHolder.domToString(tcConfigXml);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse tc-config xml", e);
        }
    }

    public void writeTcConfigFile(File kitDir, String tcConfigFilename) {
        try {
            File tempConfigFile = new File(kitDir.getAbsolutePath() + File.separatorChar + tcConfigFilename);
            try (FileOutputStream fos = new FileOutputStream(tempConfigFile);){
                fos.write(this.tcConfigContent.getBytes(Charset.defaultCharset()));
            }
            this.installedTcConfigPath = tempConfigFile.getAbsolutePath();
            logger.info("Installed Tc Config path: {}", (Object)this.installedTcConfigPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write tc-config xml to kitDir location: " + kitDir.getAbsolutePath(), e);
        }
    }

    protected abstract NodeList getServersList(Document var1, XPath var2) throws XPathExpressionException;

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public void initialize(PortAllocator portAllocator, Function<String, Boolean> support) {
        if (!this.servers.isEmpty()) {
            return;
        }
        ArrayList<TerracottaServer> servers = new ArrayList<TerracottaServer>();
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document tcConfigXml = builder.parse(new ByteArrayInputStream(this.tcConfigContent.getBytes(StandardCharsets.UTF_8)));
            NodeList serversList = this.getServersList(tcConfigXml, xPath);
            for (int i = 0; i < serversList.getLength(); ++i) {
                Node server = serversList.item(i);
                Node hostNode = (Node)xPath.evaluate("@host", server, XPathConstants.NODE);
                String hostname = hostNode == null || hostNode.getTextContent().equals("%i") || hostNode.getTextContent().equals("%h") ? "localhost" : hostNode.getTextContent();
                Node nameNode = (Node)xPath.evaluate("@name", server, XPathConstants.NODE);
                int tsaPort = this.getOrAllocate("tsa-port", server, i, xPath, portAllocator);
                int jmxPort = support.apply("jmx-port") != false ? this.getOrAllocate("jmx-port", server, i, xPath, portAllocator) : 0;
                int tsaGroupPort = this.getOrAllocate("tsa-group-port", server, i, xPath, portAllocator);
                int managementPort = support.apply("management-port") != false ? this.getOrAllocate("management-port", server, i, xPath, portAllocator) : 0;
                String symbolicName = nameNode == null ? hostname + ":" + tsaPort : nameNode.getTextContent();
                Node logNode = (Node)xPath.evaluate("*[name()='logs']", server, XPathConstants.NODE);
                TerracottaServer terracottaServer = TerracottaServer.server(symbolicName, hostname).tsaPort(tsaPort).tsaGroupPort(tsaGroupPort).managementPort(managementPort).logs(logNode == null ? null : logNode.getTextContent()).jmxPort(jmxPort);
                servers.add(terracottaServer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot parse tc-config xml", e);
        }
        this.servers.addAll(servers);
    }

    protected int getOrAllocate(String portName, Node serverNode, int idx, XPath xPath, PortAllocator portAllocator) throws XPathExpressionException {
        Node node = (Node)xPath.evaluate("*[name()='" + portName + "']", serverNode, XPathConstants.NODE);
        if (node != null) {
            int port = Integer.parseInt(node.getTextContent());
            logger.debug("Port: node[" + idx + "] " + portName + "=" + port + " (user-set)");
            return port;
        }
        int port = (Integer)portAllocator.reserve(1).next();
        logger.debug("Port: node[" + idx + "] " + portName + "=" + port + " (random)");
        this.updateServerPort(idx, portName, port);
        return port;
    }

    public List<TerracottaServer> getServers() {
        if (this.servers.isEmpty()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.servers;
    }

    public String getTcConfigContent() {
        return this.tcConfigContent;
    }

    public String getTcConfigPath() {
        return this.installedTcConfigPath;
    }

    public synchronized void updateLogsLocation(File kitDir, int stripeId) {
        this.modifyXml((tcConfigXml, xPath) -> {
            NodeList serversList = this.getServersList(tcConfigXml, xPath);
            int cnt = 1;
            for (int i = 0; i < serversList.getLength(); ++i) {
                String logsPath;
                Node server = serversList.item(i);
                Node logsNode = (Node)xPath.evaluate("*[name()='logs']", server, XPathConstants.NODE);
                if (logsNode != null) {
                    logsPath = kitDir.getAbsolutePath() + File.separatorChar + logsNode.getTextContent();
                } else {
                    logsPath = kitDir.getAbsolutePath() + File.separatorChar + "logs-" + stripeId + "-" + cnt;
                    Element newElement = tcConfigXml.createElement("logs");
                    newElement.setTextContent(logsPath);
                    server.appendChild(newElement);
                }
                this.logsPathList.add(logsPath);
                ++cnt;
            }
        });
    }

    public void updateServerHost(int serverIndex, String newServerHost) {
        this.modifyXml((tcConfigXml, xPath) -> {
            NodeList serversList = this.getServersList(tcConfigXml, xPath);
            if (serverIndex >= serversList.getLength()) {
                throw new ArrayIndexOutOfBoundsException("Server index " + serverIndex + " out of bounds: " + serversList.getLength());
            }
            Node server = serversList.item(serverIndex);
            Attr attribute = tcConfigXml.createAttribute("host");
            attribute.setValue(newServerHost);
            server.getAttributes().setNamedItem(attribute);
        });
    }

    public void updateServerName(int serverIndex, String newServerName) {
        this.modifyXml((tcConfigXml, xPath) -> {
            NodeList serversList = this.getServersList(tcConfigXml, xPath);
            if (serverIndex >= serversList.getLength()) {
                throw new ArrayIndexOutOfBoundsException("Server index " + serverIndex + " out of bounds: " + serversList.getLength());
            }
            Node server = serversList.item(serverIndex);
            Attr attribute = tcConfigXml.createAttribute("name");
            attribute.setValue(newServerName);
            server.getAttributes().setNamedItem(attribute);
        });
    }

    public void updateServerPort(int serverIndex, String portName, int port) {
        this.modifyXml((tcConfigXml, xPath) -> {
            NodeList serversList = this.getServersList(tcConfigXml, xPath);
            if (serverIndex >= serversList.getLength()) {
                throw new ArrayIndexOutOfBoundsException("Server index " + serverIndex + " out of bounds: " + serversList.getLength());
            }
            Node server = serversList.item(serverIndex);
            Node existingPortNode = (Node)xPath.evaluate("*[name()='" + portName + "']", server, XPathConstants.NODE);
            if (existingPortNode != null) {
                server.removeChild(existingPortNode);
            }
            Element portNode = tcConfigXml.createElement(portName);
            portNode.appendChild(tcConfigXml.createTextNode(Integer.toString(port)));
            server.appendChild(portNode);
        });
    }

    public void addServer(int stripeIndex, String hostname) {
        this.modifyXml((tcConfigXml, xPath) -> {
            int serverIndex = this.getServersList(tcConfigXml, xPath).getLength() + 1;
            if (serverIndex > 9 || stripeIndex > 54) {
                throw new IllegalArgumentException("Too many stripes (" + stripeIndex + ") or passives (" + serverIndex + ")");
            }
            Node serverElt = (Node)xPath.evaluate("//*[name()='servers']", tcConfigXml.getDocumentElement(), XPathConstants.NODE);
            Element node = tcConfigXml.createElement("server");
            node.setAttribute("host", hostname);
            node.setAttribute("name", "Server" + stripeIndex + "-" + serverIndex);
            serverElt.appendChild(node);
        });
    }

    public void createOrUpdateTcProperty(String name, String value) {
        this.modifyXml((tcConfigXml, xPath) -> {
            String indentation = this.guessIndentation(tcConfigXml);
            Node tcProperties = (Node)xPath.evaluate("//*[name()='tc-properties']", tcConfigXml.getDocumentElement(), XPathConstants.NODE);
            boolean createdTcProperties = false;
            if (tcProperties == null) {
                tcProperties = tcConfigXml.createElement("tc-properties");
                tcProperties.appendChild(tcConfigXml.createTextNode("\n"));
                tcConfigXml.getDocumentElement().appendChild(tcConfigXml.createTextNode(indentation));
                tcConfigXml.getDocumentElement().appendChild(tcProperties);
                tcConfigXml.getDocumentElement().appendChild(tcConfigXml.createTextNode("\n"));
                createdTcProperties = true;
            }
            Element existingProperty = null;
            NodeList tcPropertiesChildren = tcProperties.getChildNodes();
            for (int i = 0; i < tcPropertiesChildren.getLength(); ++i) {
                Node nameAttribute;
                Node tcProperty = tcPropertiesChildren.item(i);
                NamedNodeMap attributes = tcProperty.getAttributes();
                Node node = nameAttribute = attributes != null ? attributes.getNamedItem("name") : null;
                if (nameAttribute == null || !nameAttribute.getNodeValue().equals(name)) continue;
                existingProperty = (Element)tcProperty;
                break;
            }
            if (existingProperty == null) {
                tcProperties.appendChild(tcConfigXml.createTextNode(indentation + (createdTcProperties ? indentation : "")));
                Element newProperty = tcConfigXml.createElement("property");
                newProperty.setAttribute("name", name);
                newProperty.setAttribute("value", value);
                tcProperties.appendChild(newProperty);
                tcProperties.appendChild(tcConfigXml.createTextNode("\n" + indentation));
            } else {
                existingProperty.setAttribute("value", value);
            }
        });
    }

    private String guessIndentation(Document document) {
        Element documentElement = document.getDocumentElement();
        Node item = documentElement.getChildNodes().item(0);
        if (item.getNodeType() == 3) {
            Text text = (Text)item;
            return text.getTextContent().replace("\n", "").replace("\r", "");
        }
        return "  ";
    }

    public List<String> getLogsLocation() {
        return this.logsPathList;
    }

    public abstract void updateSecurityRootDirectoryLocation(String var1);

    public abstract void updateDataDirectory(String var1, String var2);

    public abstract void updateHostname(String var1, String var2);

    public abstract void updateAuditDirectoryLocation(File var1, int var2);

    public abstract List<TerracottaServer> retrieveGroupMembers(String var1, boolean var2, PortAllocator var3);

    public abstract void updateServerGroupPort(Map<ServerSymbolicName, Integer> var1);

    public abstract void updateServerTsaPort(Map<ServerSymbolicName, Integer> var1);

    public abstract Map<ServerSymbolicName, Integer> retrieveTsaPorts(boolean var1, PortAllocator var2);

    public void substituteToken(String token, String value) {
        this.tcConfigContent = this.tcConfigContent.replaceAll(token, value);
    }

    void modifyXml(XmlModifier xmlModifier) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document tcConfigXml = builder.parse(new ByteArrayInputStream(this.tcConfigContent.getBytes(StandardCharsets.UTF_8)));
            xmlModifier.modify(tcConfigXml, xPath);
            this.tcConfigContent = TcConfigHolder.domToString(tcConfigXml);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot modify tc-config xml", e);
        }
    }

    public abstract void addOffheap(String var1, String var2, String var3);

    public abstract void addDataDirectory(List<TsaStripeConfig.TsaDataDirectory> var1);

    public abstract Map<String, String> getDataDirectories();

    public abstract void addPersistencePlugin(String var1);

    public abstract List<String> getPluginServices();

    private static String domToString(Document document) throws TransformerException, IOException {
        DOMSource domSource = new DOMSource(document);
        try (StringWriter writer = new StringWriter();){
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            String string = writer.toString();
            return string;
        }
    }

    @FunctionalInterface
    protected static interface XmlModifier {
        public void modify(Document var1, XPath var2) throws Exception;
    }
}

