/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.angela.common.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;

public class JavaBinaries {
    private static final boolean WIN = System.getProperty("os.name", "").toLowerCase().contains("win");

    public static Path javaHome() {
        return Paths.get(System.getProperty("java.home"), new String[0]);
    }

    public static Optional<Path> jdkHome() {
        return JavaBinaries.jdkOf(JavaBinaries.javaHome());
    }

    public static Optional<Path> jdkOf(Path javaHome) {
        return Stream.of(javaHome, javaHome.getParent()).map(home -> home.resolve("bin").resolve(JavaBinaries.bin("javac"))).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(p -> p.getParent().getParent()).findFirst();
    }

    public static Optional<Path> find(String name) {
        return JavaBinaries.find(name, JavaBinaries.javaHome());
    }

    public static Optional<Path> find(String name, Path javaHome) {
        return JavaBinaries.jdkOf(javaHome).map(jdkHome -> Stream.of(javaHome, jdkHome)).orElse(Stream.of(javaHome)).map(home -> home.resolve("bin").resolve(JavaBinaries.bin(name))).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
    }

    public static String bin(String name) {
        return WIN ? name + ".exe" : name;
    }
}

