/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider.pkcs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Objects;
import net.schmizz.sshj.userauth.keyprovider.pkcs.KeyPairConverter;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.openssl.PEMKeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DSAPrivateKeyInfoKeyPairConverter
implements KeyPairConverter<PrivateKeyInfo> {
    private static final Logger logger = LoggerFactory.getLogger(DSAPrivateKeyInfoKeyPairConverter.class);
    private static final int P_INDEX = 0;
    private static final int Q_INDEX = 1;
    private static final int G_INDEX = 2;

    DSAPrivateKeyInfoKeyPairConverter() {
    }

    @Override
    public PEMKeyPair getKeyPair(PrivateKeyInfo privateKeyInfo) throws IOException {
        Objects.requireNonNull(privateKeyInfo, "Private Key Info required");
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier algorithm = algorithmIdentifier.getAlgorithm();
        if (!X9ObjectIdentifiers.id_dsa.equals(algorithm)) {
            throw new IllegalArgumentException(String.format("DSA Algorithm OID required [%s]", algorithm));
        }
        logger.debug("DSA Algorithm Found [{}]", (Object)algorithm);
        ASN1Integer encodedPublicKey = this.getEncodedPublicKey(privateKeyInfo);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, encodedPublicKey);
        return new PEMKeyPair(subjectPublicKeyInfo, privateKeyInfo);
    }

    private ASN1Integer getEncodedPublicKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        ASN1Integer privateKey = ASN1Integer.getInstance(privateKeyInfo.parsePrivateKey());
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        DSAParameters dsaParameters = this.getDsaParameters(algorithmIdentifier);
        BigInteger publicKey = dsaParameters.getG().modPow(privateKey.getValue(), dsaParameters.getP());
        return new ASN1Integer(publicKey);
    }

    private DSAParameters getDsaParameters(AlgorithmIdentifier algorithmIdentifier) {
        ASN1Sequence sequence = ASN1Sequence.getInstance(algorithmIdentifier.getParameters());
        ASN1Integer p = ASN1Integer.getInstance(sequence.getObjectAt(0));
        ASN1Integer q = ASN1Integer.getInstance(sequence.getObjectAt(1));
        ASN1Integer g = ASN1Integer.getInstance(sequence.getObjectAt(2));
        return new DSAParameters(p.getValue(), q.getValue(), g.getValue());
    }
}

